/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.helper.FormatHelper;
import java.util.Optional;
import org.jboss.jandex.Type;

public class DescriptionHelper {
    private DescriptionHelper() {
    }

    public static Optional<String> getDescriptionForField(Annotations annotations, Type type) {
        Optional<String> numberFormat;
        if (Classes.isDateLikeTypeOrContainedIn(type)) {
            String dateFormat = FormatHelper.getDateFormatString(annotations, type);
            if (annotations.containsKeyAndValidValue(Annotations.DESCRIPTION)) {
                return Optional.of(DescriptionHelper.getGivenDescription(annotations) + " (" + dateFormat + ")");
            }
            return Optional.of(dateFormat);
        }
        if (Classes.isNumberLikeTypeOrContainedIn(type) && (numberFormat = FormatHelper.getNumberFormatString(annotations)).isPresent()) {
            if (annotations.containsKeyAndValidValue(Annotations.DESCRIPTION)) {
                return Optional.of(DescriptionHelper.getGivenDescription(annotations) + " (" + numberFormat.get() + ")");
            }
            return numberFormat;
        }
        if (annotations.containsKeyAndValidValue(Annotations.DESCRIPTION)) {
            return Optional.of(DescriptionHelper.getGivenDescription(annotations));
        }
        return Optional.empty();
    }

    public static Optional<String> getDescriptionForType(Annotations annotations) {
        if (annotations.containsKeyAndValidValue(Annotations.DESCRIPTION)) {
            return Optional.of(DescriptionHelper.getGivenDescription(annotations));
        }
        return Optional.empty();
    }

    private static String getGivenDescription(Annotations annotations) {
        return annotations.getAnnotationValue(Annotations.DESCRIPTION).asString();
    }
}

