/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator.type;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.creator.type.Creator;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Directives;
import io.smallrye.graphql.schema.helper.TypeNameHelper;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.UnionType;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.ClassInfo;
import org.jboss.logging.Logger;

public class UnionCreator
implements Creator<UnionType> {
    private static final Logger LOG = Logger.getLogger((String)UnionCreator.class.getName());
    private final ReferenceCreator referenceCreator;
    private Directives directives;

    public UnionCreator(ReferenceCreator referenceCreator) {
        this.referenceCreator = referenceCreator;
    }

    @Override
    public UnionType create(ClassInfo classInfo, Reference reference) {
        LOG.debug((Object)("Creating union from " + classInfo.name().toString()));
        Annotations annotations = Annotations.getAnnotationsForClass(classInfo);
        String name = TypeNameHelper.getAnyTypeName(classInfo, annotations, this.referenceCreator.getTypeAutoNameStrategy(), ReferenceType.UNION, reference.getAllParametrizedTypes());
        Optional<String> maybeDescription = DescriptionHelper.getDescriptionForType(annotations);
        UnionType unionType = new UnionType(classInfo.name().toString(), name, (String)maybeDescription.orElse(null));
        unionType.setDirectiveInstances(this.getDirectiveInstances(annotations, unionType.getClassName()));
        return unionType;
    }

    @Override
    public String getDirectiveLocation() {
        return "UNION";
    }

    private List<DirectiveInstance> getDirectiveInstances(Annotations annotations, String referenceName) {
        return this.directives.buildDirectiveInstances(annotations, this.getDirectiveLocation(), referenceName);
    }

    public void setDirectives(Directives directives) {
        this.directives = directives;
    }
}

