/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.SchemaBuilderException;
import io.smallrye.graphql.schema.creator.ArgumentCreator;
import io.smallrye.graphql.schema.creator.DirectiveTypeCreator;
import io.smallrye.graphql.schema.creator.FieldCreator;
import io.smallrye.graphql.schema.creator.OperationCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.creator.type.Creator;
import io.smallrye.graphql.schema.creator.type.CustomScalarCreator;
import io.smallrye.graphql.schema.creator.type.EnumCreator;
import io.smallrye.graphql.schema.creator.type.InputTypeCreator;
import io.smallrye.graphql.schema.creator.type.InterfaceCreator;
import io.smallrye.graphql.schema.creator.type.TypeCreator;
import io.smallrye.graphql.schema.creator.type.UnionCreator;
import io.smallrye.graphql.schema.helper.BeanValidationDirectivesHelper;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Directives;
import io.smallrye.graphql.schema.helper.NamespaceHelper;
import io.smallrye.graphql.schema.helper.RolesAllowedDirectivesHelper;
import io.smallrye.graphql.schema.helper.TypeAutoNameStrategy;
import io.smallrye.graphql.schema.model.ErrorInfo;
import io.smallrye.graphql.schema.model.Namespace;
import io.smallrye.graphql.schema.model.NamespaceContainer;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.OperationType;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Schema;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class SchemaBuilder {
    private static final Logger LOG = Logger.getLogger((String)SchemaBuilder.class.getName());
    private final InputTypeCreator inputTypeCreator;
    private final TypeCreator typeCreator;
    private final FieldCreator fieldCreator;
    private final ArgumentCreator argumentCreator;
    private final InterfaceCreator interfaceCreator;
    private final EnumCreator enumCreator;
    private final ReferenceCreator referenceCreator;
    private final OperationCreator operationCreator;
    private final DirectiveTypeCreator directiveTypeCreator;
    private final UnionCreator unionCreator;
    private final CustomScalarCreator customScalarCreator;
    private final DotName FEDERATION_ANNOTATIONS_PACKAGE = DotName.createSimple((String)"io.smallrye.graphql.api.federation");

    public static Schema build(IndexView index) {
        return SchemaBuilder.build(index, TypeAutoNameStrategy.Default);
    }

    public static Schema build(IndexView index, TypeAutoNameStrategy autoNameStrategy) {
        ScanningContext.register(index);
        return new SchemaBuilder(autoNameStrategy).generateSchema();
    }

    private SchemaBuilder(TypeAutoNameStrategy autoNameStrategy) {
        this.enumCreator = new EnumCreator(autoNameStrategy);
        this.referenceCreator = new ReferenceCreator(autoNameStrategy);
        this.fieldCreator = new FieldCreator(this.referenceCreator);
        this.argumentCreator = new ArgumentCreator(this.referenceCreator);
        this.inputTypeCreator = new InputTypeCreator(this.fieldCreator);
        this.operationCreator = new OperationCreator(this.referenceCreator, this.argumentCreator);
        this.typeCreator = new TypeCreator(this.referenceCreator, this.fieldCreator, this.operationCreator);
        this.interfaceCreator = new InterfaceCreator(this.referenceCreator, this.fieldCreator, this.operationCreator);
        this.directiveTypeCreator = new DirectiveTypeCreator(this.referenceCreator);
        this.unionCreator = new UnionCreator(this.referenceCreator);
        this.customScalarCreator = new CustomScalarCreator(this.referenceCreator);
    }

    private Schema generateSchema() {
        Collection graphQLApiAnnotations = ScanningContext.getIndex().getAnnotations(Annotations.GRAPHQL_API);
        Schema schema = new Schema();
        this.addDirectiveTypes(schema);
        List allDirectiveTypes = schema.getDirectiveTypes();
        this.graphQLJavaDirectives().forEach(graphqlJavaDirectiveDotName -> {
            ClassInfo graphqlJavaDirectiveClazz = ScanningContext.getIndex().getClassByName(graphqlJavaDirectiveDotName);
            if (graphqlJavaDirectiveClazz != null) {
                allDirectiveTypes.add(this.directiveTypeCreator.create(ScanningContext.getIndex().getClassByName(graphqlJavaDirectiveDotName)));
            }
        });
        Directives directivesHelper = new Directives(allDirectiveTypes);
        this.setupDirectives(directivesHelper);
        this.setUpSchemaDirectivesAndDescription(schema, graphQLApiAnnotations, directivesHelper);
        this.addCustomScalarTypes(schema);
        this.validateNamespaceAnnotations(graphQLApiAnnotations);
        this.validateSubscriptions(graphQLApiAnnotations);
        for (AnnotationInstance graphQLApiAnnotation : graphQLApiAnnotations) {
            ClassInfo apiClass = graphQLApiAnnotation.target().asClass();
            List<MethodInfo> methods = this.getAllMethodsIncludingFromSuperClasses(apiClass);
            this.addResolvers(schema, methods);
            NamespaceHelper.getNamespace(graphQLApiAnnotation).ifPresentOrElse(namespace -> this.addNamespacedOperations((Namespace)namespace, schema, methods), () -> this.addOperations(schema, methods));
        }
        this.validateMethods(schema);
        this.addTypesToSchema(schema);
        this.addOutstandingTypesToSchema(schema);
        this.addErrors(schema);
        this.addDataFetchers(schema);
        this.referenceCreator.clear();
        return schema;
    }

    private List<String> findNamespacedMethodsErrors(Map<String, NamespaceContainer> namespaces, Set<Operation> operations) {
        return operations.stream().filter(operation -> namespaces.containsKey(operation.getName())).map(operation -> "operation name: " + operation.getName() + ", class: " + operation.getClassName() + ", method name: " + operation.getMethodName()).collect(Collectors.toList());
    }

    private void validateMethods(Schema schema) {
        List<String> queryErrors = this.findNamespacedMethodsErrors(schema.getNamespacedQueries(), schema.getQueries());
        List<String> mutationErrors = this.findNamespacedMethodsErrors(schema.getNamespacedMutations(), schema.getMutations());
        if (!queryErrors.isEmpty() || !mutationErrors.isEmpty()) {
            throw new RuntimeException("Inconsistent schema. Operation names overlap with namespaces." + queryErrors.stream().collect(Collectors.joining(", ", " queries - ", ";")) + mutationErrors.stream().collect(Collectors.joining(", ", " mutations - ", ";")));
        }
    }

    private void validateSubscriptions(Collection<AnnotationInstance> graphQLApiAnnotations) {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (AnnotationInstance annotation : graphQLApiAnnotations) {
            ClassInfo apiClass = annotation.target().asClass();
            if (!apiClass.hasDeclaredAnnotation(Annotations.NAMESPACE) && !apiClass.hasDeclaredAnnotation(Annotations.NAME)) continue;
            List<MethodInfo> methods = this.getAllMethodsIncludingFromSuperClasses(apiClass);
            for (MethodInfo methodInfo : methods) {
                Annotations annotationsForMethod = Annotations.getAnnotationsForMethod(methodInfo);
                if (!annotationsForMethod.containsOneOfTheseAnnotations(Annotations.SUBCRIPTION)) continue;
                errors.add((CallSite)((Object)("class: " + apiClass.name().toString() + ", method: " + methodInfo.name())));
            }
        }
        if (!errors.isEmpty()) {
            throw new RuntimeException("Subscriptions can't be nested. Move your subscriptions to another @GraphQLApi class, not marked @Namespace or @Name. Check these places: " + String.join((CharSequence)"; ", errors));
        }
    }

    private void validateNamespaceAnnotations(Collection<AnnotationInstance> graphQLApiAnnotations) {
        List errorClasses = graphQLApiAnnotations.stream().map(annotation -> annotation.target().asClass()).filter(classInfo -> classInfo.hasDeclaredAnnotation(Annotations.NAMESPACE) && classInfo.hasDeclaredAnnotation(Annotations.NAME)).map(classInfo -> classInfo.name().toString()).collect(Collectors.toList());
        if (!errorClasses.isEmpty()) {
            throw new RuntimeException("You can only use one of the annotations - @Name or @Namespace over the GraphQLClientApi interface. Please, fix the following classes: " + String.join((CharSequence)", ", errorClasses));
        }
    }

    private List<MethodInfo> getAllMethodsIncludingFromSuperClasses(ClassInfo classInfo) {
        ClassInfo current = classInfo;
        IndexView index = ScanningContext.getIndex();
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        while (current != null) {
            current.methods().stream().filter(methodInfo -> !methodInfo.isSynthetic()).forEach(methods::add);
            DotName superName = classInfo.superName();
            if (superName != null) {
                current = index.getClassByName(current.superName());
                continue;
            }
            current = null;
        }
        return methods;
    }

    private void addDirectiveTypes(Schema schema) {
        for (AnnotationInstance annotationInstance : ScanningContext.getIndex().getAnnotations(Annotations.DIRECTIVE)) {
            ClassInfo classInfo = annotationInstance.target().asClass();
            boolean federationEnabled = Boolean.getBoolean("smallrye.graphql.federation.enabled");
            DotName packageName = classInfo.name().packagePrefixName();
            if (packageName != null && packageName.toString().startsWith(this.FEDERATION_ANNOTATIONS_PACKAGE.toString()) && !federationEnabled || this.isGraphQLJavaDirective(classInfo)) continue;
            schema.addDirectiveType(this.directiveTypeCreator.create(classInfo));
        }
        schema.addDirectiveType(BeanValidationDirectivesHelper.CONSTRAINT_DIRECTIVE_TYPE);
        schema.addDirectiveType(RolesAllowedDirectivesHelper.ROLES_ALLOWED_DIRECTIVE_TYPE);
    }

    private void addCustomScalarTypes(Schema schema) {
        Collection annotations = ScanningContext.getIndex().getAnnotations(Annotations.CUSTOM_SCALAR);
        for (AnnotationInstance annotationInstance : annotations) {
            schema.addCustomScalarType(this.customScalarCreator.create(annotationInstance.target().asClass(), annotationInstance.value().asString()));
        }
    }

    private void setupDirectives(Directives directives) {
        this.customScalarCreator.setDirectives(directives);
        this.inputTypeCreator.setDirectives(directives);
        this.typeCreator.setDirectives(directives);
        this.interfaceCreator.setDirectives(directives);
        this.enumCreator.setDirectives(directives);
        this.fieldCreator.setDirectives(directives);
        this.argumentCreator.setDirectives(directives);
        this.operationCreator.setDirectives(directives);
        this.unionCreator.setDirectives(directives);
    }

    private void addTypesToSchema(Schema schema) {
        this.createAndAddToSchema(ReferenceType.INPUT, this.inputTypeCreator, arg_0 -> ((Schema)schema).addInput(arg_0));
        this.createAndAddToSchema(ReferenceType.TYPE, this.typeCreator, arg_0 -> ((Schema)schema).addType(arg_0));
        this.createAndAddToSchema(ReferenceType.INTERFACE, this.interfaceCreator, arg_0 -> ((Schema)schema).addInterface(arg_0));
        this.createAndAddToSchema(ReferenceType.UNION, this.unionCreator, arg_0 -> ((Schema)schema).addUnion(arg_0));
        this.createAndAddToSchema(ReferenceType.ENUM, this.enumCreator, arg_0 -> ((Schema)schema).addEnum(arg_0));
    }

    private void addOutstandingTypesToSchema(Schema schema) {
        boolean keepGoing = false;
        if (this.findOutstandingAndAddToSchema(ReferenceType.INPUT, this.inputTypeCreator, arg_0 -> ((Schema)schema).containsInput(arg_0), arg_0 -> ((Schema)schema).addInput(arg_0))) {
            keepGoing = true;
        }
        if (this.findOutstandingAndAddToSchema(ReferenceType.TYPE, this.typeCreator, arg_0 -> ((Schema)schema).containsType(arg_0), arg_0 -> ((Schema)schema).addType(arg_0))) {
            keepGoing = true;
        }
        if (this.findOutstandingAndAddToSchema(ReferenceType.INTERFACE, this.interfaceCreator, arg_0 -> ((Schema)schema).containsInterface(arg_0), arg_0 -> ((Schema)schema).addInterface(arg_0))) {
            keepGoing = true;
        }
        if (this.findOutstandingAndAddToSchema(ReferenceType.UNION, this.unionCreator, arg_0 -> ((Schema)schema).containsUnion(arg_0), arg_0 -> ((Schema)schema).addUnion(arg_0))) {
            keepGoing = true;
        }
        if (this.findOutstandingAndAddToSchema(ReferenceType.ENUM, this.enumCreator, arg_0 -> ((Schema)schema).containsEnum(arg_0), arg_0 -> ((Schema)schema).addEnum(arg_0))) {
            keepGoing = true;
        }
        if (keepGoing) {
            this.addOutstandingTypesToSchema(schema);
        }
    }

    private void addErrors(Schema schema) {
        Collection errorAnnotations = ScanningContext.getIndex().getAnnotations(Annotations.ERROR_CODE);
        if (errorAnnotations != null && !errorAnnotations.isEmpty()) {
            for (AnnotationInstance errorAnnotation : errorAnnotations) {
                AnnotationTarget annotationTarget = errorAnnotation.target();
                if (annotationTarget.kind().equals((Object)AnnotationTarget.Kind.CLASS)) {
                    ClassInfo exceptionClass = annotationTarget.asClass();
                    AnnotationValue value = errorAnnotation.value();
                    if (value != null && value.asString() != null && !value.asString().isEmpty()) {
                        schema.addError(new ErrorInfo(exceptionClass.name().toString(), value.asString()));
                        continue;
                    }
                    LOG.warn((Object)("Ignoring @ErrorCode on " + String.valueOf(annotationTarget) + " - Annotation value is not set"));
                    continue;
                }
                LOG.warn((Object)("Ignoring @ErrorCode on " + String.valueOf(annotationTarget) + " - Wrong target, only apply to CLASS [" + annotationTarget.kind().toString() + "]"));
            }
        }
    }

    private void addDataFetchers(Schema schema) {
        Collection datafetcherAnnotations = ScanningContext.getIndex().getAnnotations(Annotations.DATAFETCHER);
        if (datafetcherAnnotations != null && !datafetcherAnnotations.isEmpty()) {
            for (AnnotationInstance datafetcherAnnotation : datafetcherAnnotations) {
                AnnotationTarget annotationTarget = datafetcherAnnotation.target();
                if (!annotationTarget.kind().equals((Object)AnnotationTarget.Kind.CLASS)) continue;
                ClassInfo datafetcherClass = annotationTarget.asClass();
                AnnotationValue forClass = datafetcherAnnotation.value("forClass");
                AnnotationValue isWrapped = datafetcherAnnotation.value("isWrapped");
                LOG.info((Object)("Adding custom datafetcher for " + forClass.asClass().name().toString() + " [" + datafetcherClass.simpleName() + "]"));
                if (isWrapped != null && isWrapped.asBoolean()) {
                    schema.addWrappedDataFetcher(forClass.asClass().name().toString(), datafetcherClass.simpleName());
                    continue;
                }
                schema.addFieldDataFetcher(forClass.asClass().name().toString(), datafetcherClass.simpleName());
            }
        }
    }

    private <T> void createAndAddToSchema(ReferenceType referenceType, Creator<T> creator, Consumer<T> consumer) {
        Queue<Reference> queue = this.referenceCreator.values(referenceType);
        while (!queue.isEmpty()) {
            Reference reference = queue.poll();
            ClassInfo classInfo = ScanningContext.getIndex().getClassByName(DotName.createSimple((String)reference.getClassName()));
            consumer.accept(creator.create(classInfo, reference));
        }
    }

    private <T> boolean findOutstandingAndAddToSchema(ReferenceType referenceType, Creator<T> creator, Predicate<String> contains, Consumer<T> consumer) {
        boolean keepGoing = false;
        Queue<Reference> values = this.referenceCreator.values(referenceType);
        while (!values.isEmpty()) {
            Reference reference = values.poll();
            ClassInfo classInfo = ScanningContext.getIndex().getClassByName(DotName.createSimple((String)reference.getClassName()));
            if (contains.test(reference.getName())) continue;
            consumer.accept(creator.create(classInfo, reference));
            keepGoing = true;
        }
        return keepGoing;
    }

    private void addNamespacedOperations(Namespace namespace, Schema schema, List<MethodInfo> methodInfoList) {
        for (MethodInfo methodInfo : methodInfoList) {
            Annotations annotationsForMethod = Annotations.getAnnotationsForMethod(methodInfo);
            if (annotationsForMethod.containsOneOfTheseAnnotations(Annotations.QUERY)) {
                Operation query = this.operationCreator.createOperation(methodInfo, OperationType.QUERY, null);
                schema.addNamespacedQuery(namespace, query);
                continue;
            }
            if (!annotationsForMethod.containsOneOfTheseAnnotations(Annotations.MUTATION)) continue;
            Operation mutation = this.operationCreator.createOperation(methodInfo, OperationType.MUTATION, null);
            schema.addNamespacedMutation(namespace, mutation);
        }
    }

    private void addOperations(Schema schema, List<MethodInfo> methodInfoList) {
        for (MethodInfo methodInfo : methodInfoList) {
            Annotations annotationsForMethod = Annotations.getAnnotationsForMethod(methodInfo);
            if (annotationsForMethod.containsOneOfTheseAnnotations(Annotations.QUERY)) {
                Operation query = this.operationCreator.createOperation(methodInfo, OperationType.QUERY, null);
                schema.addQuery(query);
                continue;
            }
            if (annotationsForMethod.containsOneOfTheseAnnotations(Annotations.MUTATION)) {
                Operation mutation = this.operationCreator.createOperation(methodInfo, OperationType.MUTATION, null);
                schema.addMutation(mutation);
                continue;
            }
            if (!annotationsForMethod.containsOneOfTheseAnnotations(Annotations.SUBCRIPTION)) continue;
            Operation subscription = this.operationCreator.createOperation(methodInfo, OperationType.SUBSCRIPTION, null);
            schema.addSubscription(subscription);
        }
    }

    private void addResolvers(Schema schema, List<MethodInfo> methodInfoList) {
        for (MethodInfo methodInfo : methodInfoList) {
            Annotations annotationsForMethod = Annotations.getAnnotationsForMethod(methodInfo);
            if (!annotationsForMethod.containsOneOfTheseAnnotations(Annotations.RESOLVER)) continue;
            Operation resolver = this.operationCreator.createOperation(methodInfo, OperationType.RESOLVER, null);
            String className = resolver.getClassName();
            String resolverClassName = className.substring(className.lastIndexOf(".") + 1);
            resolver.setName(resolverClassName + resolver.getName());
            schema.addResolver(resolver);
        }
    }

    private void setUpSchemaDirectivesAndDescription(Schema schema, Collection<AnnotationInstance> graphQLApiAnnotations, Directives directivesHelper) {
        HashSet<String> directiveClassNames = new HashSet<String>();
        for (AnnotationInstance graphQLApiAnnotation : graphQLApiAnnotations) {
            Annotations annotations = Annotations.getAnnotationsForClass(graphQLApiAnnotation.target().asClass());
            this.getSchemaDirectives(schema, directiveClassNames, annotations, directivesHelper, String.valueOf(graphQLApiAnnotation.target().asClass().name()));
            this.getDescription(annotations).ifPresent(description -> {
                if (schema.getDescription() == null) {
                    schema.setDescription(description);
                } else {
                    LOG.warn((Object)"Duplicate @description annotation for @GraphQLApi class");
                }
            });
        }
    }

    private Optional<String> getDescription(Annotations annotations) {
        return DescriptionHelper.getDescriptionForType(annotations);
    }

    private void getSchemaDirectives(Schema schema, Set<String> directiveClassNames, Annotations annotations, Directives directivesHelper, String schemaClassName) {
        schema.getDirectiveInstances().addAll(directivesHelper.buildDirectiveInstances(annotations, "SCHEMA", schemaClassName).stream().map(directiveInstance -> {
            String directiveClassName = directiveInstance.getType().getClassName();
            if (!directiveInstance.getType().isRepeatable() && !directiveClassNames.add(directiveClassName)) {
                throw new SchemaBuilderException("The @" + directiveInstance.getType().getName() + " directive is not repeatable, but was used more than once in the GraphQL schema.");
            }
            return directiveInstance;
        }).collect(Collectors.toList()));
    }

    private boolean isGraphQLJavaDirective(ClassInfo classOfDirective) {
        return this.graphQLJavaDirectives().anyMatch(arg_0 -> ((DotName)classOfDirective.name()).equals(arg_0));
    }

    private Stream<DotName> graphQLJavaDirectives() {
        return Stream.of(Annotations.ONE_OF);
    }
}

