/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.typesafe.cdi;

import io.smallrye.graphql.client.impl.GraphQLClientsConfiguration;
import io.smallrye.graphql.client.impl.typesafe.cdi.TypesafeGraphQLClientBean;
import io.smallrye.graphql.client.typesafe.api.GraphQLClientApi;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;

public class TypesafeGraphQLClientExtension
implements Extension {
    private static final Logger log = Logger.getLogger(TypesafeGraphQLClientExtension.class);
    private final List<Class<?>> apis = new ArrayList();

    public void registerGraphQLClientApis(@Observes @WithAnnotations(value={GraphQLClientApi.class}) ProcessAnnotatedType<?> type) {
        Class javaClass = type.getAnnotatedType().getJavaClass();
        if (javaClass.isInterface()) {
            log.infof("register %s", (Object)javaClass.getName());
            this.apis.add(javaClass);
        } else {
            log.error((Object)"failed to register", (Throwable)new IllegalArgumentException("a GraphQlClientApi must be an interface: " + javaClass.getName()));
        }
    }

    public void createProxies(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        GraphQLClientsConfiguration clientsConfiguration = GraphQLClientsConfiguration.getInstance();
        for (Class<?> api : this.apis) {
            afterBeanDiscovery.addBean(new TypesafeGraphQLClientBean(api));
            clientsConfiguration.initTypesafeClientApi(api);
        }
    }
}

