/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.typesafe;

import io.smallrye.graphql.client.GraphQLClientException;
import io.smallrye.graphql.client.InvalidResponseException;
import io.smallrye.graphql.client.impl.ResponseReader;
import io.smallrye.graphql.client.impl.typesafe.json.JsonReader;
import io.smallrye.graphql.client.impl.typesafe.json.JsonUtils;
import io.smallrye.graphql.client.impl.typesafe.reflection.MethodInvocation;
import io.smallrye.graphql.client.typesafe.api.ErrorOr;
import io.smallrye.graphql.client.typesafe.api.TypesafeResponse;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonPatch;
import jakarta.json.JsonPointer;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonCollectors;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ResultBuilder {
    private static final JsonBuilderFactory jsonBuilderFactory = Json.createBuilderFactory(null);
    private final MethodInvocation method;
    private final JsonObject response;
    private final String responseString;
    private final Integer statusCode;
    private final String statusMessage;
    private JsonObject data;
    private JsonObject extensions;
    private Map<String, List<String>> transportMeta;
    private static final JsonPatch ERROR_MARK = Json.createPatchBuilder().add("/__typename", ErrorOr.class.getSimpleName()).build();

    public ResultBuilder(MethodInvocation method, String responseString, boolean allowUnexpectedResponseFields) {
        this(method, responseString, null, null, null, allowUnexpectedResponseFields);
    }

    public ResultBuilder(MethodInvocation method, String responseString, Integer statusCode, String statusMessage, Map<String, List<String>> transportMeta, boolean allowUnexpectedResponseFields) {
        this.method = method;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.responseString = responseString;
        this.transportMeta = transportMeta;
        this.response = ResponseReader.parseGraphQLResponse(responseString, allowUnexpectedResponseFields);
    }

    public Object read() {
        Object result;
        JsonObject value;
        if (this.response == null) {
            throw new InvalidResponseException("Unexpected response. Code=" + this.statusCode + ", message=\"" + this.statusMessage + "\", body=\"" + this.responseString + "\"");
        }
        this.data = this.readData();
        this.readErrors();
        if (this.data == null) {
            return null;
        }
        Object object = value = this.method.isSingle() ? (JsonValue)this.data.get((Object)this.method.getName()) : this.data;
        if (this.method.getReturnType().isTypesafeResponse()) {
            this.extensions = this.readExtensions();
            result = JsonReader.readJsonTypesafeResponse(this.method.toString(), this.method.getReturnType(), (JsonValue)value, null);
            result = TypesafeResponse.withTransportMetaAndExtensions((TypesafeResponse)((TypesafeResponse)result), this.transportMeta, (JsonObject)this.extensions);
        } else {
            result = JsonReader.readJson(this.method.toString(), this.method.getReturnType(), (JsonValue)value, null);
        }
        return result;
    }

    private JsonObject readData() {
        if (!this.response.containsKey((Object)"data") || this.response.isNull("data")) {
            return null;
        }
        JsonObject data = this.response.getJsonObject("data");
        if (this.method.isSingle() && !data.containsKey((Object)this.method.getName())) {
            throw new InvalidResponseException("No data for '" + this.method.getName() + "'");
        }
        return data;
    }

    private void readErrors() {
        if (!this.response.containsKey((Object)"errors") || this.response.isNull("errors")) {
            return;
        }
        JsonArray jsonErrors = this.response.getJsonArray("errors");
        if (jsonErrors == null) {
            return;
        }
        JsonArray unapplied = (JsonArray)jsonErrors.stream().filter(error -> !this.apply((JsonValue)error)).collect(JsonCollectors.toJsonArray());
        if (unapplied.isEmpty()) {
            return;
        }
        throw new GraphQLClientException("errors from service", unapplied.stream().map(ResponseReader::readError).collect(Collectors.toList()));
    }

    private boolean apply(JsonValue error) {
        List<Object> path = ResultBuilder.getPath(error);
        if (this.data == null || path == null) {
            return false;
        }
        JsonPointer pointer = Json.createPointer((String)path.stream().map(Object::toString).collect(Collectors.joining("/", "/", "")));
        if (!this.exists(pointer)) {
            return false;
        }
        JsonArrayBuilder errors = jsonBuilderFactory.createArrayBuilder();
        if (pointer.containsValue((JsonStructure)this.data) && JsonUtils.isListOf(pointer.getValue((JsonStructure)this.data), ErrorOr.class.getSimpleName())) {
            pointer.getValue((JsonStructure)this.data).asJsonArray().forEach(arg_0 -> ((JsonArrayBuilder)errors).add(arg_0));
        }
        errors.add((JsonValue)ERROR_MARK.apply((JsonStructure)((JsonObject)error)));
        this.data = (JsonObject)pointer.replace((JsonStructure)this.data, (JsonValue)errors.build());
        return true;
    }

    private JsonObject readExtensions() {
        if (!this.response.containsKey((Object)"extensions") || this.response.isNull("extensions")) {
            return null;
        }
        return this.response.getJsonObject("extensions");
    }

    private boolean exists(JsonPointer pointer) {
        try {
            pointer.containsValue((JsonStructure)this.data);
            return true;
        }
        catch (JsonException e) {
            return false;
        }
    }

    private static List<Object> getPath(JsonValue jsonValue) {
        JsonValue value = (JsonValue)jsonValue.asJsonObject().get((Object)"path");
        JsonArray jsonArray = value != null && value.getValueType().equals((Object)JsonValue.ValueType.ARRAY) ? value.asJsonArray() : null;
        return jsonArray == null ? null : jsonArray.stream().map(JsonUtils::toValue).collect(Collectors.toList());
    }
}

