/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.core;

import io.smallrye.graphql.client.core.Buildable;
import io.smallrye.graphql.client.core.exceptions.BuildException;
import io.smallrye.graphql.client.impl.core.AbstractOperation;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class OperationImpl
extends AbstractOperation {
    public String build() {
        StringBuilder builder = new StringBuilder();
        switch (this.getType()) {
            case QUERY: {
                builder.append("query");
                break;
            }
            case MUTATION: {
                builder.append("mutation");
                break;
            }
            case SUBSCRIPTION: {
                builder.append("subscription");
                break;
            }
            default: {
                throw new BuildException("Operation type must be one of QUERY, MUTATION or SUBSCRIPTION");
            }
        }
        builder.append(" ");
        builder.append(this.getName());
        if (!this.getVariables().isEmpty()) {
            this._buildVariables(builder);
        }
        if (!this.getDirectives().isEmpty()) {
            this._buildDirectives(builder);
        }
        if (this.getFields().isEmpty()) {
            throw new BuildException("An operation must have at least one root field.");
        }
        this._buildFields(builder);
        return builder.toString();
    }

    private void _buildVariables(StringBuilder builder) {
        this.buildWrapper(builder, this::getVariables, ", ", "(", ")");
    }

    private void _buildDirectives(StringBuilder builder) {
        String directives = this.getDirectives().stream().map(Buildable::build).collect(Collectors.joining());
        if (String.valueOf(builder.charAt(builder.length() - 1)).equals(" ")) {
            directives = directives.trim();
        }
        builder.append(directives);
    }

    private void _buildFields(StringBuilder builder) {
        this.buildWrapper(builder, this::getFields, " ", "{", "}");
    }

    private void buildWrapper(StringBuilder builder, Supplier<List<?>> getMethod, String delimiter, String prefix, String suffix) {
        StringJoiner stringJoiner = new StringJoiner(delimiter, prefix, suffix);
        getMethod.get().forEach(buildableObject -> stringJoiner.add(((Buildable)buildableObject).build()));
        builder.append(stringJoiner);
    }
}

