/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl;

import io.smallrye.graphql.client.impl.GraphQLClientConfiguration;
import io.smallrye.graphql.client.impl.SmallRyeGraphQLClientLogging;
import io.smallrye.graphql.client.impl.TypesafeClientConfigurationReader;
import io.smallrye.mutiny.Uni;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class GraphQLClientsConfiguration {
    private static final Map<ClassLoader, GraphQLClientsConfiguration> INSTANCES = new WeakHashMap<ClassLoader, GraphQLClientsConfiguration>();
    private static volatile boolean singleApplication = false;
    Config mpConfig = ConfigProvider.getConfig();
    private final Map<String, GraphQLClientConfiguration> clients = new HashMap<String, GraphQLClientConfiguration>();

    public static void setSingleApplication(boolean singleApplication) {
        GraphQLClientsConfiguration.singleApplication = singleApplication;
    }

    public static GraphQLClientsConfiguration getInstance() {
        ClassLoader key = singleApplication ? null : Thread.currentThread().getContextClassLoader();
        return INSTANCES.computeIfAbsent(key, x -> new GraphQLClientsConfiguration());
    }

    public static void clear() {
        INSTANCES.clear();
    }

    public GraphQLClientsConfiguration() {
        HashSet<String> detectedClientNames = new HashSet<String>();
        for (String propertyName : this.mpConfig.getPropertyNames()) {
            String key;
            if (!propertyName.matches("^[A-Za-z0-9-_.$]+/mp-graphql/.+$") || this.clients.containsKey(key = propertyName.substring(0, propertyName.indexOf("/mp-graphql")))) continue;
            detectedClientNames.add(key);
        }
        for (String clientName : detectedClientNames) {
            this.clients.put(clientName, this.readConfigurationByKey(clientName));
        }
    }

    private GraphQLClientConfiguration readConfigurationByKey(String clientName) {
        Optional keystore;
        Optional truststore;
        GraphQLClientConfiguration configuration = new GraphQLClientConfiguration();
        this.mpConfig.getOptionalValue(clientName + "/mp-graphql/url", String.class).ifPresent(configuration::setUrl);
        configuration.setHeaders(GraphQLClientsConfiguration.getConfiguredHeaders(clientName, this.mpConfig));
        configuration.setDynamicHeaders(new HashMap<String, Uni<String>>());
        configuration.setInitPayload(GraphQLClientsConfiguration.getConfiguredInitPayload(clientName, this.mpConfig));
        Optional subprotocolList = this.mpConfig.getOptionalValue(clientName + "/mp-graphql/subprotocols", String[].class);
        configuration.setWebsocketSubprotocols(new ArrayList<String>());
        if (subprotocolList.isPresent()) {
            for (String s : (String[])subprotocolList.get()) {
                configuration.getWebsocketSubprotocols().add(s);
            }
        }
        if ((truststore = this.mpConfig.getOptionalValue(clientName + "/mp-graphql/truststore", String.class)).isPresent()) {
            configuration.setTrustStore((String)truststore.get());
            configuration.setTrustStorePassword(this.mpConfig.getOptionalValue(clientName + "/mp-graphql/truststorePassword", String.class).orElse(null));
            configuration.setTrustStoreType(this.mpConfig.getOptionalValue(clientName + "/mp-graphql/truststoreType", String.class).orElse(null));
        }
        if ((keystore = this.mpConfig.getOptionalValue(clientName + "/mp-graphql/keystore", String.class)).isPresent()) {
            configuration.setKeyStore((String)keystore.get());
            configuration.setKeyStorePassword(this.mpConfig.getOptionalValue(clientName + "/mp-graphql/keystorePassword", String.class).orElse(null));
            configuration.setKeyStoreType(this.mpConfig.getOptionalValue(clientName + "/mp-graphql/keystoreType", String.class).orElse(null));
        }
        this.mpConfig.getOptionalValue(clientName + "/mp-graphql/proxyHost", String.class).ifPresent(configuration::setProxyHost);
        this.mpConfig.getOptionalValue(clientName + "/mp-graphql/proxyPort", Integer.class).ifPresent(configuration::setProxyPort);
        this.mpConfig.getOptionalValue(clientName + "/mp-graphql/proxyUsername", String.class).ifPresent(configuration::setProxyUsername);
        this.mpConfig.getOptionalValue(clientName + "/mp-graphql/proxyPassword", String.class).ifPresent(configuration::setProxyPassword);
        this.mpConfig.getOptionalValue(clientName + "/mp-graphql/maxRedirects", Integer.class).ifPresent(configuration::setMaxRedirects);
        this.mpConfig.getOptionalValue(clientName + "/mp-graphql/websocketInitializationTimeout", Integer.class).ifPresent(configuration::setWebsocketInitializationTimeout);
        this.mpConfig.getOptionalValue(clientName + "/mp-graphql/executeSingleOperationsOverWebsocket", Boolean.class).ifPresent(configuration::setExecuteSingleOperationsOverWebsocket);
        this.mpConfig.getOptionalValue(clientName + "/mp-graphql/allowUnexpectedResponseFields", Boolean.class).ifPresent(configuration::setAllowUnexpectedResponseFields);
        return configuration;
    }

    @Deprecated
    public void addTypesafeClientApis(List<Class<?>> apis) {
        if (apis == null) {
            SmallRyeGraphQLClientLogging.log.apisNotSet();
            return;
        }
        apis.forEach(this::initTypesafeClientApi);
    }

    public void initTypesafeClientApi(Class<?> api) {
        TypesafeClientConfigurationReader reader = new TypesafeClientConfigurationReader(api);
        this.clients.merge(reader.getConfigKey(), reader.getClientConfiguration(), GraphQLClientConfiguration::merge);
    }

    public GraphQLClientConfiguration getClient(String key) {
        return this.clients.computeIfAbsent(key, this::readConfigurationByKey);
    }

    public Map<String, GraphQLClientConfiguration> getClients() {
        return this.clients;
    }

    public void addClient(String key, GraphQLClientConfiguration config) {
        this.clients.put(key, config);
    }

    public static Map<String, String> getConfiguredHeaders(String configKey, Config config) {
        String prefix = configKey + "/mp-graphql/header/";
        return GraphQLClientsConfiguration.extractMapOfString(config, prefix);
    }

    public static Map<String, Object> getConfiguredInitPayload(String configKey, Config config) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String prefix = configKey + "/mp-graphql/initPayload/";
        map.putAll(GraphQLClientsConfiguration.extractMapOfString(config, prefix));
        return map;
    }

    private static Map<String, String> extractMapOfString(Config config, String prefix) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String propertyName : config.getPropertyNames()) {
            if (!propertyName.startsWith(prefix)) continue;
            String name = propertyName.substring(prefix.length());
            String value = (String)config.getValue(propertyName, String.class);
            map.put(name, value);
        }
        return map;
    }
}

