/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.apiimpl;

import io.smallrye.faulttolerance.api.CircuitBreakerState;
import io.smallrye.faulttolerance.api.CustomBackoffStrategy;
import io.smallrye.faulttolerance.api.ExponentialBackoff;
import io.smallrye.faulttolerance.api.FibonacciBackoff;
import io.smallrye.faulttolerance.api.RateLimit;
import io.smallrye.faulttolerance.api.RateLimitType;
import io.smallrye.faulttolerance.api.TypedGuard;
import io.smallrye.faulttolerance.apiimpl.AsyncInvocation;
import io.smallrye.faulttolerance.apiimpl.BasicMeteredOperationImpl;
import io.smallrye.faulttolerance.apiimpl.BuilderEagerDependencies;
import io.smallrye.faulttolerance.apiimpl.BuilderLazyDependencies;
import io.smallrye.faulttolerance.apiimpl.EventHandlers;
import io.smallrye.faulttolerance.apiimpl.GuardCommon;
import io.smallrye.faulttolerance.apiimpl.LazyTypedGuard;
import io.smallrye.faulttolerance.basicconfig.BasicFaultToleranceOperation;
import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.Invocation;
import io.smallrye.faulttolerance.core.async.RememberEventLoop;
import io.smallrye.faulttolerance.core.async.SyncAsyncSplit;
import io.smallrye.faulttolerance.core.async.ThreadOffload;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.fallback.Fallback;
import io.smallrye.faulttolerance.core.fallback.FallbackFunction;
import io.smallrye.faulttolerance.core.invocation.AsyncSupport;
import io.smallrye.faulttolerance.core.invocation.ConstantInvoker;
import io.smallrye.faulttolerance.core.metrics.DelegatingMetricsCollector;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import io.smallrye.faulttolerance.core.retry.BackOff;
import io.smallrye.faulttolerance.core.retry.ConstantBackOff;
import io.smallrye.faulttolerance.core.retry.CustomBackOff;
import io.smallrye.faulttolerance.core.retry.ExponentialBackOff;
import io.smallrye.faulttolerance.core.retry.FibonacciBackOff;
import io.smallrye.faulttolerance.core.retry.Jitter;
import io.smallrye.faulttolerance.core.retry.RandomJitter;
import io.smallrye.faulttolerance.core.retry.ThreadSleepDelay;
import io.smallrye.faulttolerance.core.retry.TimerDelay;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.stopwatch.SystemStopwatch;
import io.smallrye.faulttolerance.core.util.Durations;
import io.smallrye.faulttolerance.core.util.ExceptionDecision;
import io.smallrye.faulttolerance.core.util.Preconditions;
import io.smallrye.faulttolerance.core.util.SneakyThrow;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

public final class TypedGuardImpl<V, T>
implements TypedGuard<T> {
    private final FaultToleranceStrategy<V> strategy;
    private final AsyncSupport<V, T> asyncSupport;
    private final EventHandlers eventHandlers;

    TypedGuardImpl(FaultToleranceStrategy<V> strategy, AsyncSupport<V, T> asyncSupport, EventHandlers eventHandlers) {
        this.strategy = strategy;
        this.asyncSupport = asyncSupport;
        this.eventHandlers = eventHandlers;
    }

    public T call(Callable<T> action) throws Exception {
        return this.guard(action);
    }

    public T get(Supplier<T> action) {
        try {
            return (T)this.guard(action::get);
        }
        catch (Exception e) {
            throw SneakyThrow.sneakyThrow((Throwable)e);
        }
    }

    private T guard(Callable<T> action) throws Exception {
        AsyncInvocation<V, T> asyncInvocation = GuardCommon.asyncInvocation(action, this.asyncSupport);
        return GuardCommon.guard(action, this.strategy, asyncInvocation, this.eventHandlers, null);
    }

    public T guard(Callable<T> action, AsyncInvocation<V, T> asyncInvocation, Consumer<FaultToleranceContext<?>> contextModifier) throws Exception {
        return GuardCommon.guard(action, this.strategy, asyncInvocation, this.eventHandlers, contextModifier);
    }

    public static class BuilderImpl<V, T>
    implements TypedGuard.Builder<T> {
        private final BuilderEagerDependencies eagerDependencies;
        private final Supplier<BuilderLazyDependencies> lazyDependencies;
        private final AsyncSupport<V, T> asyncSupport;
        private String description;
        private boolean descriptionSet;
        private BulkheadBuilderImpl<V, T> bulkheadBuilder;
        private CircuitBreakerBuilderImpl<V, T> circuitBreakerBuilder;
        private FallbackBuilderImpl<V, T> fallbackBuilder;
        private RateLimitBuilderImpl<V, T> rateLimitBuilder;
        private RetryBuilderImpl<V, T> retryBuilder;
        private TimeoutBuilderImpl<V, T> timeoutBuilder;
        private boolean offloadToAnotherThread;
        private Executor offloadExecutor;

        public BuilderImpl(BuilderEagerDependencies eagerDependencies, Supplier<BuilderLazyDependencies> lazyDependencies, Type valueType) {
            this.eagerDependencies = eagerDependencies;
            this.lazyDependencies = lazyDependencies;
            this.asyncSupport = GuardCommon.asyncSupport(valueType);
            this.description = UUID.randomUUID().toString();
            this.descriptionSet = false;
        }

        public TypedGuard.Builder<T> withDescription(String value) {
            this.description = (String)Preconditions.checkNotNull((Object)value, (String)"Description must be set");
            this.descriptionSet = true;
            return this;
        }

        public TypedGuard.Builder.BulkheadBuilder<T> withBulkhead() {
            return new BulkheadBuilderImpl(this);
        }

        public TypedGuard.Builder.CircuitBreakerBuilder<T> withCircuitBreaker() {
            return new CircuitBreakerBuilderImpl(this);
        }

        public TypedGuard.Builder.FallbackBuilder<T> withFallback() {
            return new FallbackBuilderImpl(this);
        }

        public TypedGuard.Builder.RateLimitBuilder<T> withRateLimit() {
            return new RateLimitBuilderImpl(this);
        }

        public TypedGuard.Builder.RetryBuilder<T> withRetry() {
            return new RetryBuilderImpl(this);
        }

        public TypedGuard.Builder.TimeoutBuilder<T> withTimeout() {
            return new TimeoutBuilderImpl(this);
        }

        public TypedGuard.Builder<T> withThreadOffload(boolean value) {
            this.offloadToAnotherThread = value;
            return this;
        }

        public TypedGuard.Builder<T> withThreadOffloadExecutor(Executor executor) {
            this.offloadExecutor = (Executor)Preconditions.checkNotNull((Object)executor, (String)"Thread offload executor must be set");
            return this;
        }

        public TypedGuard<T> build() {
            this.eagerInitialization();
            return new LazyTypedGuard(cfg -> new TypedGuardImpl<V, T>(this.buildStrategy((String)cfg, this.lazyDependencies.get()), this.asyncSupport, this.buildEventHandlers()));
        }

        final void eagerInitialization() {
            if (this.circuitBreakerBuilder != null && this.circuitBreakerBuilder.name != null) {
                this.eagerDependencies.cbMaintenance().registerName(this.circuitBreakerBuilder.name);
            }
        }

        final EventHandlers buildEventHandlers() {
            Consumer<CircuitBreakerEvents.StateTransition> cbMaintenanceEventHandler = null;
            if (this.circuitBreakerBuilder != null && this.circuitBreakerBuilder.name != null) {
                cbMaintenanceEventHandler = this.eagerDependencies.cbMaintenance().stateTransitionEventHandler(this.circuitBreakerBuilder.name);
            }
            return new EventHandlers(this.bulkheadBuilder != null ? this.bulkheadBuilder.onAccepted : null, this.bulkheadBuilder != null ? this.bulkheadBuilder.onRejected : null, this.bulkheadBuilder != null ? this.bulkheadBuilder.onFinished : null, cbMaintenanceEventHandler, this.circuitBreakerBuilder != null ? this.circuitBreakerBuilder.onStateChange : null, this.circuitBreakerBuilder != null ? this.circuitBreakerBuilder.onSuccess : null, this.circuitBreakerBuilder != null ? this.circuitBreakerBuilder.onFailure : null, this.circuitBreakerBuilder != null ? this.circuitBreakerBuilder.onPrevented : null, this.rateLimitBuilder != null ? this.rateLimitBuilder.onPermitted : null, this.rateLimitBuilder != null ? this.rateLimitBuilder.onRejected : null, this.retryBuilder != null ? this.retryBuilder.onRetry : null, this.retryBuilder != null ? this.retryBuilder.onSuccess : null, this.retryBuilder != null ? this.retryBuilder.onFailure : null, this.timeoutBuilder != null ? this.timeoutBuilder.onTimeout : null, this.timeoutBuilder != null ? this.timeoutBuilder.onFinished : null);
        }

        final FaultToleranceStrategy<V> buildStrategy(String id, BuilderLazyDependencies lazyDependencies) {
            BasicFaultToleranceOperation op = new BasicFaultToleranceOperation(id, this.bulkheadBuilder, this.circuitBreakerBuilder, this.rateLimitBuilder, this.retryBuilder, this.timeoutBuilder, this.retryBuilder != null ? this.retryBuilder.exponentialBackoffBuilder : null, this.retryBuilder != null ? this.retryBuilder.fibonacciBackoffBuilder : null);
            op.validate();
            Invocation result = Invocation.invocation();
            Executor executor = this.offloadExecutor != null ? this.offloadExecutor : lazyDependencies.asyncExecutor();
            result = new SyncAsyncSplit((FaultToleranceStrategy)new ThreadOffload((FaultToleranceStrategy)result, executor, this.offloadToAnotherThread), (FaultToleranceStrategy)result);
            if (lazyDependencies.ftEnabled() && op.hasBulkhead()) {
                result = new io.smallrye.faulttolerance.core.bulkhead.Bulkhead((FaultToleranceStrategy)result, this.description, op.getBulkhead().value(), op.getBulkhead().waitingTaskQueue(), this.bulkheadBuilder.syncQueueingEnabled);
            }
            if (lazyDependencies.ftEnabled() && op.hasTimeout()) {
                result = new io.smallrye.faulttolerance.core.timeout.Timeout((FaultToleranceStrategy)result, this.description, Durations.timeInMillis((long)op.getTimeout().value(), (ChronoUnit)op.getTimeout().unit()), lazyDependencies.timer());
            }
            if (lazyDependencies.ftEnabled() && op.hasRateLimit()) {
                result = new io.smallrye.faulttolerance.core.rate.limit.RateLimit((FaultToleranceStrategy)result, this.description, op.getRateLimit().value(), Durations.timeInMillis((long)op.getRateLimit().window(), (ChronoUnit)op.getRateLimit().windowUnit()), Durations.timeInMillis((long)op.getRateLimit().minSpacing(), (ChronoUnit)op.getRateLimit().minSpacingUnit()), op.getRateLimit().type(), (Stopwatch)SystemStopwatch.INSTANCE);
            }
            if (lazyDependencies.ftEnabled() && op.hasCircuitBreaker()) {
                result = new CircuitBreaker((FaultToleranceStrategy)result, this.description, GuardCommon.createExceptionDecision(op.getCircuitBreaker().skipOn(), op.getCircuitBreaker().failOn(), this.circuitBreakerBuilder.whenPredicate), Durations.timeInMillis((long)op.getCircuitBreaker().delay(), (ChronoUnit)op.getCircuitBreaker().delayUnit()), op.getCircuitBreaker().requestVolumeThreshold(), op.getCircuitBreaker().failureRatio(), op.getCircuitBreaker().successThreshold(), (Stopwatch)SystemStopwatch.INSTANCE, lazyDependencies.timer());
                if (this.circuitBreakerBuilder.name != null) {
                    CircuitBreaker circuitBreaker = (CircuitBreaker)result;
                    this.eagerDependencies.cbMaintenance().register(this.circuitBreakerBuilder.name, circuitBreaker);
                }
            }
            if (lazyDependencies.ftEnabled() && op.hasRetry()) {
                Supplier<BackOff> backoff = BuilderImpl.prepareRetryBackoff(op, this.retryBuilder);
                Consumer<Throwable> beforeRetryAction = this.retryBuilder.beforeRetry;
                result = new io.smallrye.faulttolerance.core.retry.Retry((FaultToleranceStrategy)result, this.description, GuardCommon.createResultDecision(this.retryBuilder.whenResultPredicate), GuardCommon.createExceptionDecision(op.getRetry().abortOn(), op.getRetry().retryOn(), this.retryBuilder.whenExceptionPredicate), (long)op.getRetry().maxRetries(), Durations.timeInMillis((long)op.getRetry().maxDuration(), (ChronoUnit)op.getRetry().durationUnit()), () -> new ThreadSleepDelay((BackOff)backoff.get()), () -> new TimerDelay((BackOff)backoff.get(), lazyDependencies.timer()), (Stopwatch)SystemStopwatch.INSTANCE, beforeRetryAction != null ? ctx -> beforeRetryAction.accept(ctx.failure) : null);
            }
            FallbackFunction fallbackFunction = FallbackFunction.ignore();
            ExceptionDecision exceptionDecision = ExceptionDecision.IGNORE;
            if (this.fallbackBuilder != null) {
                fallbackFunction = this.asyncSupport != null ? ctx -> {
                    try {
                        return this.asyncSupport.toFuture(ConstantInvoker.of(this.fallbackBuilder.handler.apply(ctx.failure)));
                    }
                    catch (Exception e) {
                        return Future.ofError((Throwable)e);
                    }
                } : ctx -> Future.from(() -> this.fallbackBuilder.handler.apply(ctx.failure));
                exceptionDecision = GuardCommon.createExceptionDecision(this.fallbackBuilder.skipOn, this.fallbackBuilder.applyOn, this.fallbackBuilder.whenPredicate);
            }
            result = new Fallback((FaultToleranceStrategy)result, this.description, fallbackFunction, exceptionDecision);
            MetricsProvider metricsProvider = lazyDependencies.metricsProvider();
            if (metricsProvider.isEnabled()) {
                MeteredOperation defaultOperation = this.buildMeteredOperation();
                result = new DelegatingMetricsCollector((FaultToleranceStrategy)result, metricsProvider, defaultOperation);
            }
            result = new SyncAsyncSplit((FaultToleranceStrategy)new RememberEventLoop((FaultToleranceStrategy)result, lazyDependencies.eventLoop(), this.offloadToAnotherThread), (FaultToleranceStrategy)result);
            return result;
        }

        private MeteredOperation buildMeteredOperation() {
            return new BasicMeteredOperationImpl(this.descriptionSet, this.description, this.asyncSupport != null, this.bulkheadBuilder != null, this.circuitBreakerBuilder != null, false, this.rateLimitBuilder != null, this.retryBuilder != null, this.timeoutBuilder != null);
        }

        private static Supplier<BackOff> prepareRetryBackoff(BasicFaultToleranceOperation op, RetryBuilderImpl<?, ?> retryBuilder) {
            Jitter jitter;
            long delayMs = Durations.timeInMillis((long)op.getRetry().delay(), (ChronoUnit)op.getRetry().delayUnit());
            long jitterMs = Durations.timeInMillis((long)op.getRetry().jitter(), (ChronoUnit)op.getRetry().jitterDelayUnit());
            Object object = jitter = jitterMs == 0L ? Jitter.ZERO : new RandomJitter(jitterMs);
            if (op.hasExponentialBackoff()) {
                int factor = op.getExponentialBackoff().factor();
                long maxDelayMs = Durations.timeInMillis((long)op.getExponentialBackoff().maxDelay(), (ChronoUnit)op.getExponentialBackoff().maxDelayUnit());
                return () -> new ExponentialBackOff(delayMs, factor, jitter, maxDelayMs);
            }
            if (op.hasFibonacciBackoff()) {
                long maxDelayMs = Durations.timeInMillis((long)op.getFibonacciBackoff().maxDelay(), (ChronoUnit)op.getFibonacciBackoff().maxDelayUnit());
                return () -> new FibonacciBackOff(delayMs, jitter, maxDelayMs);
            }
            if (retryBuilder.customBackoffBuilder != null) {
                Supplier<CustomBackoffStrategy> strategy = retryBuilder.customBackoffBuilder.strategy;
                return () -> {
                    CustomBackoffStrategy instance = (CustomBackoffStrategy)strategy.get();
                    instance.init(delayMs);
                    return new CustomBackOff(arg_0 -> ((CustomBackoffStrategy)instance).nextDelayInMillis(arg_0));
                };
            }
            return () -> new ConstantBackOff(delayMs, jitter);
        }

        static class BulkheadBuilderImpl<V, T>
        implements TypedGuard.Builder.BulkheadBuilder<T>,
        Supplier<Bulkhead> {
            private final BuilderImpl<V, T> parent;
            private int limit = 10;
            private int queueSize = 10;
            private boolean syncQueueingEnabled;
            private Runnable onAccepted;
            private Runnable onRejected;
            private Runnable onFinished;

            BulkheadBuilderImpl(BuilderImpl<V, T> parent) {
                this.parent = parent;
            }

            public TypedGuard.Builder.BulkheadBuilder<T> limit(int value) {
                this.limit = Preconditions.check((int)value, (value >= 1 ? 1 : 0) != 0, (String)"Limit must be >= 1");
                return this;
            }

            public TypedGuard.Builder.BulkheadBuilder<T> queueSize(int value) {
                this.queueSize = Preconditions.check((int)value, (value >= 1 ? 1 : 0) != 0, (String)"Queue size must be >= 1");
                return this;
            }

            public TypedGuard.Builder.BulkheadBuilder<T> enableSynchronousQueueing() {
                this.syncQueueingEnabled = true;
                return this;
            }

            public TypedGuard.Builder.BulkheadBuilder<T> onAccepted(Runnable callback) {
                this.onAccepted = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Accepted callback must be set");
                return this;
            }

            public TypedGuard.Builder.BulkheadBuilder<T> onRejected(Runnable callback) {
                this.onRejected = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Rejected callback must be set");
                return this;
            }

            public TypedGuard.Builder.BulkheadBuilder<T> onFinished(Runnable callback) {
                this.onFinished = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Finished callback must be set");
                return this;
            }

            public TypedGuard.Builder<T> done() {
                try {
                    Math.addExact(this.limit, this.queueSize);
                }
                catch (ArithmeticException e) {
                    throw new IllegalStateException("Bulkhead capacity overflow, " + this.limit + " + " + this.queueSize + " = " + (this.limit + this.queueSize));
                }
                this.parent.bulkheadBuilder = this;
                return this.parent;
            }

            @Override
            public Bulkhead get() {
                return new Bulkhead(){

                    public int value() {
                        return limit;
                    }

                    public int waitingTaskQueue() {
                        return queueSize;
                    }

                    public Class<? extends Annotation> annotationType() {
                        return Bulkhead.class;
                    }
                };
            }
        }

        static class CircuitBreakerBuilderImpl<V, T>
        implements TypedGuard.Builder.CircuitBreakerBuilder<T>,
        Supplier<org.eclipse.microprofile.faulttolerance.CircuitBreaker> {
            private final BuilderImpl<V, T> parent;
            private Class<? extends Throwable>[] failOn = new Class[]{Throwable.class};
            private Class<? extends Throwable>[] skipOn = new Class[0];
            private boolean setBasedExceptionDecisionDefined = false;
            private Predicate<Throwable> whenPredicate;
            private long delay = 5000L;
            private ChronoUnit delayUnit = ChronoUnit.MILLIS;
            private int requestVolumeThreshold = 20;
            private double failureRatio = 0.5;
            private int successThreshold = 1;
            private String name;
            private Consumer<CircuitBreakerState> onStateChange;
            private Runnable onSuccess;
            private Runnable onFailure;
            private Runnable onPrevented;

            CircuitBreakerBuilderImpl(BuilderImpl<V, T> parent) {
                this.parent = parent;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> failOn(Collection<Class<? extends Throwable>> value) {
                this.failOn = ((Collection)Preconditions.checkNotNull(value, (String)"Exceptions considered failure must be set")).toArray(new Class[0]);
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> failOn(Class<? extends Throwable> value) {
                this.failOn = new Class[]{(Class)Preconditions.checkNotNull(value, (String)"Exception considered failure must be set")};
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> skipOn(Collection<Class<? extends Throwable>> value) {
                this.skipOn = ((Collection)Preconditions.checkNotNull(value, (String)"Exceptions considered success must be set")).toArray(new Class[0]);
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> skipOn(Class<? extends Throwable> value) {
                this.skipOn = new Class[]{(Class)Preconditions.checkNotNull(value, (String)"Exception considered success must be set")};
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> when(Predicate<Throwable> value) {
                this.whenPredicate = (Predicate)Preconditions.checkNotNull(value, (String)"Exception predicate must be set");
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> delay(long value, ChronoUnit unit) {
                Preconditions.check((long)value, (value >= 0L ? 1 : 0) != 0, (String)"Delay must be >= 0");
                Preconditions.checkNotNull((Object)unit, (String)"Delay unit must be set");
                this.delay = value;
                this.delayUnit = unit;
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> requestVolumeThreshold(int value) {
                this.requestVolumeThreshold = Preconditions.check((int)value, (value >= 1 ? 1 : 0) != 0, (String)"Request volume threshold must be >= 1");
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> failureRatio(double value) {
                this.failureRatio = Preconditions.check((double)value, (value >= 0.0 && value <= 1.0 ? 1 : 0) != 0, (String)"Failure ratio must be >= 0 and <= 1");
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> successThreshold(int value) {
                this.successThreshold = Preconditions.check((int)value, (value >= 1 ? 1 : 0) != 0, (String)"Success threshold must be >= 1");
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> name(String value) {
                this.name = (String)Preconditions.checkNotNull((Object)value, (String)"Circuit breaker name must be set");
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> onStateChange(Consumer<CircuitBreakerState> callback) {
                this.onStateChange = (Consumer)Preconditions.checkNotNull(callback, (String)"On state change callback must be set");
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> onSuccess(Runnable callback) {
                this.onSuccess = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"On success callback must be set");
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> onFailure(Runnable callback) {
                this.onFailure = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"On failure callback must be set");
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> onPrevented(Runnable callback) {
                this.onPrevented = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"On prevented callback must be set");
                return this;
            }

            public TypedGuard.Builder<T> done() {
                if (this.whenPredicate != null && this.setBasedExceptionDecisionDefined) {
                    throw new IllegalStateException("The when() method may not be combined with failOn() / skipOn()");
                }
                this.parent.circuitBreakerBuilder = this;
                return this.parent;
            }

            @Override
            public org.eclipse.microprofile.faulttolerance.CircuitBreaker get() {
                return new org.eclipse.microprofile.faulttolerance.CircuitBreaker(){

                    public Class<? extends Throwable>[] failOn() {
                        return failOn;
                    }

                    public Class<? extends Throwable>[] skipOn() {
                        return skipOn;
                    }

                    public long delay() {
                        return delay;
                    }

                    public ChronoUnit delayUnit() {
                        return delayUnit;
                    }

                    public int requestVolumeThreshold() {
                        return requestVolumeThreshold;
                    }

                    public double failureRatio() {
                        return failureRatio;
                    }

                    public int successThreshold() {
                        return successThreshold;
                    }

                    public Class<? extends Annotation> annotationType() {
                        return org.eclipse.microprofile.faulttolerance.CircuitBreaker.class;
                    }
                };
            }
        }

        static class FallbackBuilderImpl<V, T>
        implements TypedGuard.Builder.FallbackBuilder<T> {
            private final BuilderImpl<V, T> parent;
            private Function<Throwable, T> handler;
            private Class<? extends Throwable>[] applyOn = new Class[]{Throwable.class};
            private Class<? extends Throwable>[] skipOn = new Class[0];
            private boolean setBasedExceptionDecisionDefined = false;
            private Predicate<Throwable> whenPredicate;

            FallbackBuilderImpl(BuilderImpl<V, T> parent) {
                this.parent = parent;
            }

            public TypedGuard.Builder.FallbackBuilder<T> handler(Supplier<T> value) {
                Preconditions.checkNotNull(value, (String)"Fallback handler must be set");
                this.handler = ignored -> value.get();
                return this;
            }

            public TypedGuard.Builder.FallbackBuilder<T> handler(Function<Throwable, T> value) {
                this.handler = (Function)Preconditions.checkNotNull(value, (String)"Fallback handler must be set");
                return this;
            }

            public TypedGuard.Builder.FallbackBuilder<T> applyOn(Collection<Class<? extends Throwable>> value) {
                this.applyOn = ((Collection)Preconditions.checkNotNull(value, (String)"Exceptions to apply fallback on must be set")).toArray(new Class[0]);
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.FallbackBuilder<T> applyOn(Class<? extends Throwable> value) {
                this.applyOn = new Class[]{(Class)Preconditions.checkNotNull(value, (String)"Exception to apply fallback on must be set")};
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.FallbackBuilder<T> skipOn(Collection<Class<? extends Throwable>> value) {
                this.skipOn = ((Collection)Preconditions.checkNotNull(value, (String)"Exceptions to skip fallback on must be set")).toArray(new Class[0]);
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.FallbackBuilder<T> skipOn(Class<? extends Throwable> value) {
                this.skipOn = new Class[]{(Class)Preconditions.checkNotNull(value, (String)"Exception to skip fallback on must be set")};
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.FallbackBuilder<T> when(Predicate<Throwable> value) {
                this.whenPredicate = (Predicate)Preconditions.checkNotNull(value, (String)"Exception predicate must be set");
                return this;
            }

            public TypedGuard.Builder<T> done() {
                Preconditions.checkNotNull(this.handler, (String)"Fallback handler must be set");
                if (this.whenPredicate != null && this.setBasedExceptionDecisionDefined) {
                    throw new IllegalStateException("The when() method may not be combined with applyOn() / skipOn()");
                }
                this.parent.fallbackBuilder = this;
                return this.parent;
            }
        }

        static class RateLimitBuilderImpl<V, T>
        implements TypedGuard.Builder.RateLimitBuilder<T>,
        Supplier<RateLimit> {
            private final BuilderImpl<V, T> parent;
            private int maxInvocations = 100;
            private long timeWindow = 1L;
            private ChronoUnit timeWindowUnit = ChronoUnit.SECONDS;
            private long minSpacing = 0L;
            private ChronoUnit minSpacingUnit = ChronoUnit.SECONDS;
            private RateLimitType type = RateLimitType.FIXED;
            private Runnable onPermitted;
            private Runnable onRejected;

            RateLimitBuilderImpl(BuilderImpl<V, T> parent) {
                this.parent = parent;
            }

            public TypedGuard.Builder.RateLimitBuilder<T> limit(int value) {
                this.maxInvocations = Preconditions.check((int)value, (value >= 1 ? 1 : 0) != 0, (String)"Rate limit must be >= 1");
                return this;
            }

            public TypedGuard.Builder.RateLimitBuilder<T> window(long value, ChronoUnit unit) {
                Preconditions.check((long)value, (value >= 1L ? 1 : 0) != 0, (String)"Time window length must be >= 1");
                Preconditions.checkNotNull((Object)unit, (String)"Time window length unit must be set");
                this.timeWindow = value;
                this.timeWindowUnit = unit;
                return this;
            }

            public TypedGuard.Builder.RateLimitBuilder<T> minSpacing(long value, ChronoUnit unit) {
                Preconditions.check((long)value, (value >= 0L ? 1 : 0) != 0, (String)"Min spacing must be >= 0");
                Preconditions.checkNotNull((Object)unit, (String)"Min spacing unit must be set");
                this.minSpacing = value;
                this.minSpacingUnit = unit;
                return this;
            }

            public TypedGuard.Builder.RateLimitBuilder<T> type(RateLimitType value) {
                this.type = (RateLimitType)Preconditions.checkNotNull((Object)value, (String)"Time window type must be set");
                return this;
            }

            public TypedGuard.Builder.RateLimitBuilder<T> onPermitted(Runnable callback) {
                this.onPermitted = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Permitted callback must be set");
                return this;
            }

            public TypedGuard.Builder.RateLimitBuilder<T> onRejected(Runnable callback) {
                this.onRejected = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Rejected callback must be set");
                return this;
            }

            public TypedGuard.Builder<T> done() {
                this.parent.rateLimitBuilder = this;
                return this.parent;
            }

            @Override
            public RateLimit get() {
                return new RateLimit(){

                    public int value() {
                        return maxInvocations;
                    }

                    public long window() {
                        return timeWindow;
                    }

                    public ChronoUnit windowUnit() {
                        return timeWindowUnit;
                    }

                    public long minSpacing() {
                        return minSpacing;
                    }

                    public ChronoUnit minSpacingUnit() {
                        return minSpacingUnit;
                    }

                    public RateLimitType type() {
                        return type;
                    }

                    public Class<? extends Annotation> annotationType() {
                        return RateLimit.class;
                    }
                };
            }
        }

        static class RetryBuilderImpl<V, T>
        implements TypedGuard.Builder.RetryBuilder<T>,
        Supplier<Retry> {
            private final BuilderImpl<V, T> parent;
            private int maxRetries = 3;
            private long delay = 0L;
            private ChronoUnit delayUnit = ChronoUnit.MILLIS;
            private long maxDuration = 180000L;
            private ChronoUnit maxDurationUnit = ChronoUnit.MILLIS;
            private long jitter = 200L;
            private ChronoUnit jitterUnit = ChronoUnit.MILLIS;
            private Class<? extends Throwable>[] retryOn = new Class[]{Exception.class};
            private Class<? extends Throwable>[] abortOn = new Class[0];
            private boolean setBasedExceptionDecisionDefined = false;
            private Predicate<Throwable> whenExceptionPredicate;
            private Predicate<Object> whenResultPredicate;
            private Consumer<Throwable> beforeRetry;
            private ExponentialBackoffBuilderImpl<V, T> exponentialBackoffBuilder;
            private FibonacciBackoffBuilderImpl<V, T> fibonacciBackoffBuilder;
            private CustomBackoffBuilderImpl<V, T> customBackoffBuilder;
            private Runnable onRetry;
            private Runnable onSuccess;
            private Runnable onFailure;

            RetryBuilderImpl(BuilderImpl<V, T> parent) {
                this.parent = parent;
            }

            public TypedGuard.Builder.RetryBuilder<T> maxRetries(int value) {
                this.maxRetries = Preconditions.check((int)value, (value >= -1 ? 1 : 0) != 0, (String)"Max retries must be >= -1");
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> delay(long value, ChronoUnit unit) {
                Preconditions.check((long)value, (value >= 0L ? 1 : 0) != 0, (String)"Delay must be >= 0");
                Preconditions.checkNotNull((Object)unit, (String)"Delay unit must be set");
                this.delay = value;
                this.delayUnit = unit;
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> maxDuration(long value, ChronoUnit unit) {
                Preconditions.check((long)value, (value >= 0L ? 1 : 0) != 0, (String)"Max duration must be >= 0");
                Preconditions.checkNotNull((Object)unit, (String)"Max duration unit must be set");
                this.maxDuration = value;
                this.maxDurationUnit = unit;
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> jitter(long value, ChronoUnit unit) {
                Preconditions.check((long)value, (value >= 0L ? 1 : 0) != 0, (String)"Jitter must be >= 0");
                Preconditions.checkNotNull((Object)unit, (String)"Jitter unit must be set");
                this.jitter = value;
                this.jitterUnit = unit;
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> retryOn(Collection<Class<? extends Throwable>> value) {
                this.retryOn = ((Collection)Preconditions.checkNotNull(value, (String)"Exceptions to retry on must be set")).toArray(new Class[0]);
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> retryOn(Class<? extends Throwable> value) {
                this.retryOn = new Class[]{(Class)Preconditions.checkNotNull(value, (String)"Exception to retry on must be set")};
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> abortOn(Collection<Class<? extends Throwable>> value) {
                this.abortOn = ((Collection)Preconditions.checkNotNull(value, (String)"Exceptions to abort retrying on must be set")).toArray(new Class[0]);
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> abortOn(Class<? extends Throwable> value) {
                this.abortOn = new Class[]{(Class)Preconditions.checkNotNull(value, (String)"Exception to abort retrying on must be set")};
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> whenResult(Predicate<Object> value) {
                this.whenResultPredicate = (Predicate)Preconditions.checkNotNull(value, (String)"Result predicate must be set");
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> whenException(Predicate<Throwable> value) {
                this.whenExceptionPredicate = (Predicate)Preconditions.checkNotNull(value, (String)"Exception predicate must be set");
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> beforeRetry(Runnable value) {
                Preconditions.checkNotNull((Object)value, (String)"Before retry handler must be set");
                this.beforeRetry = ignored -> value.run();
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> beforeRetry(Consumer<Throwable> value) {
                this.beforeRetry = (Consumer)Preconditions.checkNotNull(value, (String)"Before retry handler must be set");
                return this;
            }

            public TypedGuard.Builder.RetryBuilder.ExponentialBackoffBuilder<T> withExponentialBackoff() {
                return new ExponentialBackoffBuilderImpl(this);
            }

            public TypedGuard.Builder.RetryBuilder.FibonacciBackoffBuilder<T> withFibonacciBackoff() {
                return new FibonacciBackoffBuilderImpl(this);
            }

            public TypedGuard.Builder.RetryBuilder.CustomBackoffBuilder<T> withCustomBackoff() {
                return new CustomBackoffBuilderImpl(this);
            }

            public TypedGuard.Builder.RetryBuilder<T> onRetry(Runnable callback) {
                this.onRetry = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Retry callback must be set");
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> onSuccess(Runnable callback) {
                this.onSuccess = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Success callback must be set");
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> onFailure(Runnable callback) {
                this.onFailure = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Failure callback must be set");
                return this;
            }

            public TypedGuard.Builder<T> done() {
                if (this.whenExceptionPredicate != null && this.setBasedExceptionDecisionDefined) {
                    throw new IllegalStateException("The whenException() method may not be combined with retryOn()/abortOn()");
                }
                int backoffStrategies = 0;
                if (this.exponentialBackoffBuilder != null) {
                    ++backoffStrategies;
                }
                if (this.fibonacciBackoffBuilder != null) {
                    ++backoffStrategies;
                }
                if (this.customBackoffBuilder != null) {
                    ++backoffStrategies;
                }
                if (backoffStrategies > 1) {
                    throw new IllegalStateException("Only one backoff strategy may be set for retry");
                }
                this.parent.retryBuilder = this;
                return this.parent;
            }

            @Override
            public Retry get() {
                return new Retry(){

                    public int maxRetries() {
                        return maxRetries;
                    }

                    public long delay() {
                        return delay;
                    }

                    public ChronoUnit delayUnit() {
                        return delayUnit;
                    }

                    public long maxDuration() {
                        return maxDuration;
                    }

                    public ChronoUnit durationUnit() {
                        return maxDurationUnit;
                    }

                    public long jitter() {
                        return jitter;
                    }

                    public ChronoUnit jitterDelayUnit() {
                        return jitterUnit;
                    }

                    public Class<? extends Throwable>[] retryOn() {
                        return retryOn;
                    }

                    public Class<? extends Throwable>[] abortOn() {
                        return abortOn;
                    }

                    public Class<? extends Annotation> annotationType() {
                        return Retry.class;
                    }
                };
            }

            static class ExponentialBackoffBuilderImpl<V, T>
            implements TypedGuard.Builder.RetryBuilder.ExponentialBackoffBuilder<T>,
            Supplier<ExponentialBackoff> {
                private final RetryBuilderImpl<V, T> parent;
                private int factor = 2;
                private long maxDelay = 60000L;
                private ChronoUnit maxDelayUnit = ChronoUnit.MILLIS;

                ExponentialBackoffBuilderImpl(RetryBuilderImpl<V, T> parent) {
                    this.parent = parent;
                }

                public TypedGuard.Builder.RetryBuilder.ExponentialBackoffBuilder<T> factor(int value) {
                    this.factor = Preconditions.check((int)value, (value >= 1 ? 1 : 0) != 0, (String)"Factor must be >= 1");
                    return this;
                }

                public TypedGuard.Builder.RetryBuilder.ExponentialBackoffBuilder<T> maxDelay(long value, ChronoUnit unit) {
                    Preconditions.check((long)value, (value >= 0L ? 1 : 0) != 0, (String)"Max delay must be >= 0");
                    Preconditions.checkNotNull((Object)unit, (String)"Max delay unit must be set");
                    this.maxDelay = value;
                    this.maxDelayUnit = unit;
                    return this;
                }

                public TypedGuard.Builder.RetryBuilder<T> done() {
                    this.parent.exponentialBackoffBuilder = this;
                    return this.parent;
                }

                @Override
                public ExponentialBackoff get() {
                    return new ExponentialBackoff(){

                        public int factor() {
                            return factor;
                        }

                        public long maxDelay() {
                            return maxDelay;
                        }

                        public ChronoUnit maxDelayUnit() {
                            return maxDelayUnit;
                        }

                        public Class<? extends Annotation> annotationType() {
                            return ExponentialBackoff.class;
                        }
                    };
                }
            }

            static class FibonacciBackoffBuilderImpl<V, T>
            implements TypedGuard.Builder.RetryBuilder.FibonacciBackoffBuilder<T>,
            Supplier<FibonacciBackoff> {
                private final RetryBuilderImpl<V, T> parent;
                private long maxDelay = 60000L;
                private ChronoUnit maxDelayUnit = ChronoUnit.MILLIS;

                FibonacciBackoffBuilderImpl(RetryBuilderImpl<V, T> parent) {
                    this.parent = parent;
                }

                public TypedGuard.Builder.RetryBuilder.FibonacciBackoffBuilder<T> maxDelay(long value, ChronoUnit unit) {
                    Preconditions.check((long)value, (value >= 0L ? 1 : 0) != 0, (String)"Max delay must be >= 0");
                    Preconditions.checkNotNull((Object)unit, (String)"Max delay unit must be set");
                    this.maxDelay = value;
                    this.maxDelayUnit = unit;
                    return this;
                }

                public TypedGuard.Builder.RetryBuilder<T> done() {
                    this.parent.fibonacciBackoffBuilder = this;
                    return this.parent;
                }

                @Override
                public FibonacciBackoff get() {
                    return new FibonacciBackoff(){

                        public long maxDelay() {
                            return maxDelay;
                        }

                        public ChronoUnit maxDelayUnit() {
                            return maxDelayUnit;
                        }

                        public Class<? extends Annotation> annotationType() {
                            return FibonacciBackoff.class;
                        }
                    };
                }
            }

            static class CustomBackoffBuilderImpl<V, T>
            implements TypedGuard.Builder.RetryBuilder.CustomBackoffBuilder<T> {
                private final RetryBuilderImpl<V, T> parent;
                private Supplier<CustomBackoffStrategy> strategy;

                CustomBackoffBuilderImpl(RetryBuilderImpl<V, T> parent) {
                    this.parent = parent;
                }

                public TypedGuard.Builder.RetryBuilder.CustomBackoffBuilder<T> strategy(Supplier<CustomBackoffStrategy> value) {
                    this.strategy = (Supplier)Preconditions.checkNotNull(value, (String)"Custom backoff strategy must be set");
                    return this;
                }

                public TypedGuard.Builder.RetryBuilder<T> done() {
                    Preconditions.checkNotNull(this.strategy, (String)"Custom backoff strategy must be set");
                    this.parent.customBackoffBuilder = this;
                    return this.parent;
                }
            }
        }

        static class TimeoutBuilderImpl<V, T>
        implements TypedGuard.Builder.TimeoutBuilder<T>,
        Supplier<Timeout> {
            private final BuilderImpl<V, T> parent;
            private long value = 1000L;
            private ChronoUnit unit = ChronoUnit.MILLIS;
            private Runnable onTimeout;
            private Runnable onFinished;

            TimeoutBuilderImpl(BuilderImpl<V, T> parent) {
                this.parent = parent;
            }

            public TypedGuard.Builder.TimeoutBuilder<T> duration(long value, ChronoUnit unit) {
                Preconditions.check((long)value, (value >= 0L ? 1 : 0) != 0, (String)"Timeout duration must be >= 0");
                Preconditions.checkNotNull((Object)unit, (String)"Timeout duration unit must be set");
                this.value = value;
                this.unit = unit;
                return this;
            }

            public TypedGuard.Builder.TimeoutBuilder<T> onTimeout(Runnable callback) {
                this.onTimeout = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Timeout callback must be set");
                return this;
            }

            public TypedGuard.Builder.TimeoutBuilder<T> onFinished(Runnable callback) {
                this.onFinished = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Finished callback must be set");
                return this;
            }

            public TypedGuard.Builder<T> done() {
                this.parent.timeoutBuilder = this;
                return this.parent;
            }

            @Override
            public Timeout get() {
                return new Timeout(){

                    public long value() {
                        return value;
                    }

                    public ChronoUnit unit() {
                        return unit;
                    }

                    public Class<? extends Annotation> annotationType() {
                        return Timeout.class;
                    }
                };
            }
        }
    }
}

