/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.propagators.rxjava1;

import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ThreadContext;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func1;

public class ContextPropagatorOnObservableCreateAction
implements Func1<Observable.OnSubscribe, Observable.OnSubscribe> {
    private ThreadContext threadContext;

    public ContextPropagatorOnObservableCreateAction(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    public Observable.OnSubscribe call(Observable.OnSubscribe t) {
        return new ContextCapturerObservable(t, this.threadContext.currentContextExecutor());
    }

    static final class ContextCapturerObservable<T>
    implements Observable.OnSubscribe<T> {
        final Observable.OnSubscribe<T> source;
        private Executor contextExecutor;

        public ContextCapturerObservable(Observable.OnSubscribe<T> source, Executor contextExecutor) {
            this.source = source;
            this.contextExecutor = contextExecutor;
        }

        public void call(Subscriber<? super T> t) {
            this.contextExecutor.execute(() -> this.source.call(new OnAssemblyObservableSubscriber(t, this.contextExecutor)));
        }

        static final class OnAssemblyObservableSubscriber<T>
        extends Subscriber<T> {
            final Subscriber<? super T> actual;
            private final Executor contextExecutor;

            public OnAssemblyObservableSubscriber(Subscriber<? super T> actual, Executor contextExecutor) {
                super(actual);
                this.actual = actual;
                this.contextExecutor = contextExecutor;
                actual.add((Subscription)this);
            }

            public void onError(Throwable e) {
                this.contextExecutor.execute(() -> this.actual.onError(e));
            }

            public void onNext(T t) {
                this.contextExecutor.execute(() -> this.actual.onNext(t));
            }

            public void onCompleted() {
                this.contextExecutor.execute(() -> this.actual.onCompleted());
            }
        }
    }
}

