/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.mutiny;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.openapi.OpenAPILoaderOptions;
import io.vertx.ext.web.openapi.RouterBuilderOptions;
import io.vertx.ext.web.openapi.mutiny.OpenAPIHolder;
import io.vertx.ext.web.openapi.mutiny.Operation;
import io.vertx.json.schema.SchemaParser;
import io.vertx.mutiny.ext.web.handler.AuthenticationHandler;
import io.vertx.mutiny.ext.web.handler.BodyHandler;
import io.vertx.mutiny.json.schema.SchemaRouter;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

@MutinyGen(value=io.vertx.ext.web.openapi.RouterBuilder.class)
public class RouterBuilder {
    public static final TypeArg<RouterBuilder> __TYPE_ARG = new TypeArg(obj -> new RouterBuilder((io.vertx.ext.web.openapi.RouterBuilder)obj), RouterBuilder::getDelegate);
    private final io.vertx.ext.web.openapi.RouterBuilder delegate;
    static final TypeArg<Operation> TYPE_ARG_0 = new TypeArg(o1 -> Operation.newInstance((io.vertx.ext.web.openapi.Operation)o1), o1 -> o1.getDelegate());

    public RouterBuilder(io.vertx.ext.web.openapi.RouterBuilder delegate) {
        this.delegate = delegate;
    }

    public RouterBuilder(Object delegate) {
        this.delegate = (io.vertx.ext.web.openapi.RouterBuilder)delegate;
    }

    RouterBuilder() {
        this.delegate = null;
    }

    public io.vertx.ext.web.openapi.RouterBuilder getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouterBuilder that = (RouterBuilder)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Operation operation(String operationId) {
        Operation ret = Operation.newInstance(this.delegate.operation(operationId));
        return ret;
    }

    public List<Operation> operations() {
        List<Operation> ret = this.delegate.operations().stream().map(elt -> Operation.newInstance(elt)).collect(Collectors.toList());
        return ret;
    }

    @Fluent
    public RouterBuilder bodyHandler(BodyHandler bodyHandler) {
        this.delegate.bodyHandler(bodyHandler.getDelegate());
        return this;
    }

    @Fluent
    private RouterBuilder __rootHandler(final Handler<io.vertx.mutiny.ext.web.RoutingContext> rootHandler) {
        this.delegate.rootHandler((Handler)new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                rootHandler.handle((Object)io.vertx.mutiny.ext.web.RoutingContext.newInstance((RoutingContext)event));
            }
        });
        return this;
    }

    public RouterBuilder rootHandler(Consumer<io.vertx.mutiny.ext.web.RoutingContext> rootHandler) {
        return this.__rootHandler(rootHandler != null ? rootHandler::accept : null);
    }

    @Fluent
    public RouterBuilder securityHandler(String securitySchemaName, AuthenticationHandler handler) {
        this.delegate.securityHandler(securitySchemaName, handler.getDelegate());
        return this;
    }

    @Fluent
    public RouterBuilder mountServicesFromExtensions() {
        this.delegate.mountServicesFromExtensions();
        return this;
    }

    @Fluent
    public RouterBuilder setOptions(RouterBuilderOptions options) {
        this.delegate.setOptions(options);
        return this;
    }

    public RouterBuilderOptions getOptions() {
        RouterBuilderOptions ret = this.delegate.getOptions();
        return ret;
    }

    public OpenAPIHolder getOpenAPI() {
        OpenAPIHolder ret = OpenAPIHolder.newInstance(this.delegate.getOpenAPI());
        return ret;
    }

    public SchemaRouter getSchemaRouter() {
        SchemaRouter ret = SchemaRouter.newInstance((io.vertx.json.schema.SchemaRouter)this.delegate.getSchemaRouter());
        return ret;
    }

    public io.vertx.mutiny.json.schema.SchemaParser getSchemaParser() {
        io.vertx.mutiny.json.schema.SchemaParser ret = io.vertx.mutiny.json.schema.SchemaParser.newInstance((SchemaParser)this.delegate.getSchemaParser());
        return ret;
    }

    @Fluent
    public RouterBuilder serviceExtraPayloadMapper(final Function<io.vertx.mutiny.ext.web.RoutingContext, JsonObject> serviceExtraPayloadMapper) {
        this.delegate.serviceExtraPayloadMapper((Function)new Function<RoutingContext, JsonObject>(){

            @Override
            public JsonObject apply(RoutingContext arg) {
                JsonObject ret = (JsonObject)serviceExtraPayloadMapper.apply(io.vertx.mutiny.ext.web.RoutingContext.newInstance((RoutingContext)arg));
                return ret;
            }
        });
        return this;
    }

    public io.vertx.mutiny.ext.web.Router createRouter() {
        io.vertx.mutiny.ext.web.Router ret = io.vertx.mutiny.ext.web.Router.newInstance((Router)this.delegate.createRouter());
        return ret;
    }

    public static Uni<RouterBuilder> create(io.vertx.mutiny.core.Vertx vertx, String url) {
        return AsyncResultUni.toUni(handler -> io.vertx.ext.web.openapi.RouterBuilder.create((Vertx)vertx.getDelegate(), (String)url, (Handler)new Handler<AsyncResult<io.vertx.ext.web.openapi.RouterBuilder>>(){

            public void handle(AsyncResult<io.vertx.ext.web.openapi.RouterBuilder> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RouterBuilder.newInstance((io.vertx.ext.web.openapi.RouterBuilder)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public static RouterBuilder createAndAwait(io.vertx.mutiny.core.Vertx vertx, String url) {
        return (RouterBuilder)RouterBuilder.create(vertx, url).await().indefinitely();
    }

    public static void createAndForget(io.vertx.mutiny.core.Vertx vertx, String url) {
        RouterBuilder.create(vertx, url).subscribe().with(UniHelper.NOOP);
    }

    public static Uni<RouterBuilder> create(io.vertx.mutiny.core.Vertx vertx, String url, OpenAPILoaderOptions options) {
        return AsyncResultUni.toUni(handler -> io.vertx.ext.web.openapi.RouterBuilder.create((Vertx)vertx.getDelegate(), (String)url, (OpenAPILoaderOptions)options, (Handler)new Handler<AsyncResult<io.vertx.ext.web.openapi.RouterBuilder>>(){

            public void handle(AsyncResult<io.vertx.ext.web.openapi.RouterBuilder> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RouterBuilder.newInstance((io.vertx.ext.web.openapi.RouterBuilder)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public static RouterBuilder createAndAwait(io.vertx.mutiny.core.Vertx vertx, String url, OpenAPILoaderOptions options) {
        return (RouterBuilder)RouterBuilder.create(vertx, url, options).await().indefinitely();
    }

    public static void createAndForget(io.vertx.mutiny.core.Vertx vertx, String url, OpenAPILoaderOptions options) {
        RouterBuilder.create(vertx, url, options).subscribe().with(UniHelper.NOOP);
    }

    public static RouterBuilder newInstance(io.vertx.ext.web.openapi.RouterBuilder arg) {
        return arg != null ? new RouterBuilder(arg) : null;
    }
}

