package io.vertx.mutiny.ext.web.client;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.function.Function;
import java.util.Map;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.Future;
import java.util.List;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.Handler;

/**
 * A client-side HTTP request.
 * <p>
 * Instances are created by an {@link io.vertx.mutiny.ext.web.client.WebClient} instance, via one of the methods corresponding to the specific
 * HTTP methods such as {@link io.vertx.mutiny.ext.web.client.WebClient#get}, etc...
 * <p>
 * The request shall be configured prior sending, the request is immutable and when a mutator method
 * is called, a new request is returned allowing to expose the request in a public API and apply further customization.
 * <p>
 * After the request has been configured, the methods
 * <ul>
 *   <li>{@link io.vertx.mutiny.ext.web.client.HttpRequest#send}</li>
 *   <li>{@link io.vertx.mutiny.ext.web.client.HttpRequest#sendStream}</li>
 *   <li>{@link io.vertx.mutiny.ext.web.client.HttpRequest#sendJson} ()}</li>
 *   <li>{@link io.vertx.mutiny.ext.web.client.HttpRequest#sendForm}</li>
 * </ul>
 * can be called.
 * The <code>sendXXX</code> methods perform the actual request, they can be called multiple times to perform the same HTTP
 * request at different points in time.
 * <p>
 * The handler is called back with
 * <ul>
 *   <li>an {@link io.vertx.mutiny.ext.web.client.HttpResponse} instance when the HTTP response has been received</li>
 *   <li>a failure when the HTTP request failed (like a connection error) or when the HTTP response could
 *   not be obtained (like connection or unmarshalling errors)</li>
 * </ul>
 * <p>
 * Most of the time, this client will buffer the HTTP response fully unless a specific  is used
 * such as .
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.HttpRequest original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.client.HttpRequest.class)
public class HttpRequest<T> {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpRequest> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpRequest((io.vertx.ext.web.client.HttpRequest) obj),
    HttpRequest::getDelegate
  );

  private final io.vertx.ext.web.client.HttpRequest<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public HttpRequest(io.vertx.ext.web.client.HttpRequest delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public HttpRequest(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.ext.web.client.HttpRequest)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public HttpRequest(io.vertx.ext.web.client.HttpRequest delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HttpRequest() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.ext.web.client.HttpRequest getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.ext.web.client.predicate.ResponsePredicate> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.ext.web.client.predicate.ResponsePredicate>(o1 -> io.vertx.mutiny.ext.web.client.predicate.ResponsePredicate.newInstance((io.vertx.ext.web.client.predicate.ResponsePredicate)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpRequest that = (HttpRequest) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> method(io.vertx.core.http.HttpMethod value) { 
    delegate.method(value);
    return this;
  }

  /**
   * @return the request method
   */
  public io.vertx.core.http.HttpMethod method() { 
    io.vertx.core.http.HttpMethod ret = delegate.method();
    return ret;
  }

  /**
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> port(int value) { 
    delegate.port(value);
    return this;
  }

  /**
   * @return the request port or <code>0</code> when none is set for absolute URI templates
   */
  public int port() { 
    int ret = delegate.port();
    return ret;
  }

  /**
   * @param responseCodec the response codec
   * @return a reference to this, so the API can be used fluently
   */
  public <U> io.vertx.mutiny.ext.web.client.HttpRequest<U> as(io.vertx.mutiny.ext.web.codec.BodyCodec<U> responseCodec) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<U> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.as(responseCodec.getDelegate()), responseCodec.__typeArg_0);
    return ret;
  }

  /**
   * @return the request body codec
   */
  public io.vertx.mutiny.ext.web.codec.BodyCodec<T> bodyCodec() { 
    io.vertx.mutiny.ext.web.codec.BodyCodec<T> ret = io.vertx.mutiny.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)delegate.bodyCodec(), __typeArg_0);
    return ret;
  }

  /**
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> host(String value) { 
    delegate.host(value);
    return this;
  }

  /**
   * @return the request host or <code>null</code> when none is set for absolute URI templates
   */
  public String host() { 
    String ret = delegate.host();
    return ret;
  }

  /**
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> virtualHost(String value) { 
    delegate.virtualHost(value);
    return this;
  }

  /**
   * @return the request virtual host if any or <code>null</code>
   */
  public String virtualHost() { 
    String ret = delegate.virtualHost();
    return ret;
  }

  /**
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> uri(String value) { 
    delegate.uri(value);
    return this;
  }

  /**
   * @return the request uri or <code>null</code> when none is set for absolute URI templates
   */
  public String uri() { 
    String ret = delegate.uri();
    return ret;
  }

  /**
   * @param headers The HTTP headers
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> putHeaders(io.vertx.mutiny.core.MultiMap headers) { 
    delegate.putHeaders(headers.getDelegate());
    return this;
  }

  /**
   * @param name the header name
   * @param value the header value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> putHeader(String name, String value) { 
    delegate.putHeader(name, value);
    return this;
  }

  /**
   * @return The HTTP headers
   */
  public io.vertx.mutiny.core.MultiMap headers() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    cached_0 = ret;
    return ret;
  }

  /**
   * @param id the id
   * @param password the password
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> basicAuthentication(String id, String password) { 
    delegate.basicAuthentication(id, password);
    return this;
  }

  /**
   * @param id the id
   * @param password the password
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> basicAuthentication(io.vertx.mutiny.core.buffer.Buffer id, io.vertx.mutiny.core.buffer.Buffer password) { 
    delegate.basicAuthentication(id.getDelegate(), password.getDelegate());
    return this;
  }

  /**
   * @param bearerToken the bearer token
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> bearerTokenAuthentication(String bearerToken) { 
    delegate.bearerTokenAuthentication(bearerToken);
    return this;
  }

  /**
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> ssl(Boolean value) { 
    delegate.ssl(value);
    return this;
  }

  /**
   * @return whether the request uses SSL or <code>null</code> when none is set for absolute URI templates
   */
  public Boolean ssl() { 
    Boolean ret = delegate.ssl();
    return ret;
  }

  /**
   * @param value The quantity of time in milliseconds.
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> timeout(long value) { 
    delegate.timeout(value);
    return this;
  }

  /**
   * @return the current timeout in milliseconds
   */
  public long timeout() { 
    long ret = delegate.timeout();
    return ret;
  }

  /**
   * @param paramName the param name
   * @param paramValue the param value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> addQueryParam(String paramName, String paramValue) { 
    delegate.addQueryParam(paramName, paramValue);
    return this;
  }

  /**
   * @param paramName the param name
   * @param paramValue the param value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> setQueryParam(String paramName, String paramValue) { 
    delegate.setQueryParam(paramName, paramValue);
    return this;
  }

  /**
   * @param paramName the param name
   * @param paramValue the param value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> setTemplateParam(String paramName, String paramValue) { 
    delegate.setTemplateParam(paramName, paramValue);
    return this;
  }

  /**
   * @param paramName the param name
   * @param paramValue the param value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> setTemplateParam(String paramName, List<String> paramValue) { 
    delegate.setTemplateParam(paramName, paramValue);
    return this;
  }

  /**
   * @param paramName the param name
   * @param paramValue the param value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> setTemplateParam(String paramName, java.util.Map<String, String> paramValue) { 
    delegate.setTemplateParam(paramName, paramValue);
    return this;
  }

  /**
   * @param value true if redirections should be followed
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> followRedirects(boolean value) { 
    delegate.followRedirects(value);
    return this;
  }

  /**
   * @return whether to follow request redirections
   */
  public boolean followRedirects() { 
    boolean ret = delegate.followRedirects();
    return ret;
  }

  /**
   * @param proxyOptions The proxy options
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> proxy(io.vertx.core.net.ProxyOptions proxyOptions) { 
    delegate.proxy(proxyOptions);
    return this;
  }

  /**
   * @return the proxy for this request
   */
  public io.vertx.core.net.ProxyOptions proxy() { 
    io.vertx.core.net.ProxyOptions ret = delegate.proxy();
    return ret;
  }

  /**
   * @param predicate the predicate
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> expect(Function<io.vertx.mutiny.ext.web.client.HttpResponse<Void>, io.vertx.mutiny.ext.web.client.predicate.ResponsePredicateResult> predicate) { 
    delegate.expect(new java.util.function.Function<io.vertx.ext.web.client.HttpResponse<Void>,io.vertx.ext.web.client.predicate.ResponsePredicateResult>() {
      public io.vertx.ext.web.client.predicate.ResponsePredicateResult apply(io.vertx.ext.web.client.HttpResponse<Void> arg) {
        io.vertx.mutiny.ext.web.client.predicate.ResponsePredicateResult ret = predicate.apply(io.vertx.mutiny.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)arg, TypeArg.unknown()));
        return ret.getDelegate();
      }
    });
    return this;
  }

  /**
   * @param predicate the predicate
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> expect(io.vertx.mutiny.ext.web.client.predicate.ResponsePredicate predicate) { 
    delegate.expect(predicate.getDelegate());
    return this;
  }

  /**
   * @return a read-only list of the response predicate expectations
   */
  public List<io.vertx.mutiny.ext.web.client.predicate.ResponsePredicate> expectations() { 
    List<io.vertx.mutiny.ext.web.client.predicate.ResponsePredicate> ret = delegate.expectations().stream().map(elt -> io.vertx.mutiny.ext.web.client.predicate.ResponsePredicate.newInstance((io.vertx.ext.web.client.predicate.ResponsePredicate)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * @return the current query parameters
   */
  public io.vertx.mutiny.core.MultiMap queryParams() { 
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.queryParams());
    return ret;
  }

  /**
   * @return the current request URI template parameters
   */
  public io.vertx.mutiny.uritemplate.Variables templateParams() { 
    io.vertx.mutiny.uritemplate.Variables ret = io.vertx.mutiny.uritemplate.Variables.newInstance((io.vertx.uritemplate.Variables)delegate.templateParams());
    return ret;
  }

  /**
   * @return a copy of this request
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> copy() { 
    io.vertx.mutiny.ext.web.client.HttpRequest<T> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.copy(), __typeArg_0);
    return ret;
  }

  /**
   * @param allow <code>true</code> allows use of multipart mixed encoding
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> multipartMixed(boolean allow) { 
    delegate.multipartMixed(allow);
    return this;
  }

  /**
   * @return whether multipart mixed encoding is allowed
   */
  public boolean multipartMixed() { 
    boolean ret = delegate.multipartMixed();
    return ret;
  }

  /**
   * @param traceOperation Name of operation to use in traces
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> traceOperation(String traceOperation) { 
    delegate.traceOperation(traceOperation);
    return this;
  }

  /**
   * @return the trace operation name override
   */
  public String traceOperation() { 
    String ret = delegate.traceOperation();
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> stream.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param body the body
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.web.client.HttpResponse<T>> sendStream(io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sendStream(body.getDelegate(), new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendStream(io.vertx.mutiny.core.streams.ReadStream)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param body the body
   * @return the HttpResponse<T> instance produced by the operation.
   */
  public io.vertx.mutiny.ext.web.client.HttpResponse<T> sendStreamAndAwait(io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> body) { 
    return (io.vertx.mutiny.ext.web.client.HttpResponse<T>) sendStream(body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendStream(io.vertx.mutiny.core.streams.ReadStream)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendStream(io.vertx.mutiny.core.streams.ReadStream)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendStream(io.vertx.mutiny.core.streams.ReadStream)} but you don't need to compose it with other operations.
   * @param body the body
   */
  public void sendStreamAndForget(io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> body) { 
    sendStream(body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> stream.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param body the body
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.web.client.HttpResponse<T>> sendStream(java.util.concurrent.Flow.Publisher<io.vertx.mutiny.core.buffer.Buffer> body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sendStream(io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(body,obj -> (io.vertx.core.buffer.Buffer) obj.getDelegate()).resume(), new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendStream(Flow$Publisher)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param body the body
   * @return the HttpResponse<T> instance produced by the operation.
   */
  public io.vertx.mutiny.ext.web.client.HttpResponse<T> sendStreamAndAwait(java.util.concurrent.Flow.Publisher<io.vertx.mutiny.core.buffer.Buffer> body) { 
    return (io.vertx.mutiny.ext.web.client.HttpResponse<T>) sendStream(body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendStream(Flow$Publisher)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendStream(Flow$Publisher)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendStream(Flow$Publisher)} but you don't need to compose it with other operations.
   * @param body the body
   */
  public void sendStreamAndForget(java.util.concurrent.Flow.Publisher<io.vertx.mutiny.core.buffer.Buffer> body) { 
    sendStream(body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> buffer.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param body the body
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.web.client.HttpResponse<T>> sendBuffer(io.vertx.mutiny.core.buffer.Buffer body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sendBuffer(body.getDelegate(), new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendBuffer(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param body the body
   * @return the HttpResponse<T> instance produced by the operation.
   */
  public io.vertx.mutiny.ext.web.client.HttpResponse<T> sendBufferAndAwait(io.vertx.mutiny.core.buffer.Buffer body) { 
    return (io.vertx.mutiny.ext.web.client.HttpResponse<T>) sendBuffer(body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendBuffer(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendBuffer(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendBuffer(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param body the body
   */
  public void sendBufferAndForget(io.vertx.mutiny.core.buffer.Buffer body) { 
    sendBuffer(body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> object encoded as json and the content type
   * set to <code>application/json</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param body the body
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.web.client.HttpResponse<T>> sendJsonObject(JsonObject body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sendJsonObject(body, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendJsonObject(JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param body the body
   * @return the HttpResponse<T> instance produced by the operation.
   */
  public io.vertx.mutiny.ext.web.client.HttpResponse<T> sendJsonObjectAndAwait(JsonObject body) { 
    return (io.vertx.mutiny.ext.web.client.HttpResponse<T>) sendJsonObject(body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendJsonObject(JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendJsonObject(JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendJsonObject(JsonObject)} but you don't need to compose it with other operations.
   * @param body the body
   */
  public void sendJsonObjectAndForget(JsonObject body) { 
    sendJsonObject(body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> object encoded as json and the content type
   * set to <code>application/json</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param body the body
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.web.client.HttpResponse<T>> sendJson(java.lang.Object body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sendJson(body, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendJson(Object)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param body the body
   * @return the HttpResponse<T> instance produced by the operation.
   */
  public io.vertx.mutiny.ext.web.client.HttpResponse<T> sendJsonAndAwait(java.lang.Object body) { 
    return (io.vertx.mutiny.ext.web.client.HttpResponse<T>) sendJson(body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendJson(Object)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendJson(Object)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendJson(Object)} but you don't need to compose it with other operations.
   * @param body the body
   */
  public void sendJsonAndForget(java.lang.Object body) { 
    sendJson(body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
   * set to <code>application/x-www-form-urlencoded</code>.
   * <p>
   * When the content type header is previously set to <code>multipart/form-data</code> it will be used instead.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param body the body
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.web.client.HttpResponse<T>> sendForm(io.vertx.mutiny.core.MultiMap body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sendForm(body.getDelegate(), new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendForm(io.vertx.mutiny.core.MultiMap)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param body the body
   * @return the HttpResponse<T> instance produced by the operation.
   */
  public io.vertx.mutiny.ext.web.client.HttpResponse<T> sendFormAndAwait(io.vertx.mutiny.core.MultiMap body) { 
    return (io.vertx.mutiny.ext.web.client.HttpResponse<T>) sendForm(body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendForm(io.vertx.mutiny.core.MultiMap)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendForm(io.vertx.mutiny.core.MultiMap)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendForm(io.vertx.mutiny.core.MultiMap)} but you don't need to compose it with other operations.
   * @param body the body
   */
  public void sendFormAndForget(io.vertx.mutiny.core.MultiMap body) { 
    sendForm(body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
   * set to <code>application/x-www-form-urlencoded</code>.
   * <p>
   * When the content type header is previously set to <code>multipart/form-data</code> it will be used instead.
   *
   * NOTE: the use of this method is strongly discouraged to use when the form is a <code>application/x-www-form-urlencoded</code>
   * encoded form since the charset to use must be UTF-8.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param body the body
   * @param charset 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.web.client.HttpResponse<T>> sendForm(io.vertx.mutiny.core.MultiMap body, String charset) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sendForm(body.getDelegate(), charset, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendForm(io.vertx.mutiny.core.MultiMap,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param body the body
   * @param charset 
   * @return the HttpResponse<T> instance produced by the operation.
   */
  public io.vertx.mutiny.ext.web.client.HttpResponse<T> sendFormAndAwait(io.vertx.mutiny.core.MultiMap body, String charset) { 
    return (io.vertx.mutiny.ext.web.client.HttpResponse<T>) sendForm(body, charset).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendForm(io.vertx.mutiny.core.MultiMap,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendForm(io.vertx.mutiny.core.MultiMap,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendForm(io.vertx.mutiny.core.MultiMap,String)} but you don't need to compose it with other operations.
   * @param body the body
   * @param charset 
   */
  public void sendFormAndForget(io.vertx.mutiny.core.MultiMap body, String charset) { 
    sendForm(body, charset).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
   * set to <code>multipart/form-data</code>. You may use this method to send attributes and upload files.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param body the body
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.web.client.HttpResponse<T>> sendMultipartForm(io.vertx.mutiny.ext.web.multipart.MultipartForm body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sendMultipartForm(body.getDelegate(), new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendMultipartForm(io.vertx.mutiny.ext.web.multipart.MultipartForm)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param body the body
   * @return the HttpResponse<T> instance produced by the operation.
   */
  public io.vertx.mutiny.ext.web.client.HttpResponse<T> sendMultipartFormAndAwait(io.vertx.mutiny.ext.web.multipart.MultipartForm body) { 
    return (io.vertx.mutiny.ext.web.client.HttpResponse<T>) sendMultipartForm(body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendMultipartForm(io.vertx.mutiny.ext.web.multipart.MultipartForm)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendMultipartForm(io.vertx.mutiny.ext.web.multipart.MultipartForm)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.web.client.HttpRequest#sendMultipartForm(io.vertx.mutiny.ext.web.multipart.MultipartForm)} but you don't need to compose it with other operations.
   * @param body the body
   */
  public void sendMultipartFormAndForget(io.vertx.mutiny.ext.web.multipart.MultipartForm body) { 
    sendMultipartForm(body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Send a request, the <code>handler</code> will receive the response as an {@link io.vertx.mutiny.ext.web.client.HttpResponse}.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.web.client.HttpResponse<T>> send() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.send(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#send}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the HttpResponse<T> instance produced by the operation.
   */
  public io.vertx.mutiny.ext.web.client.HttpResponse<T> sendAndAwait() { 
    return (io.vertx.mutiny.ext.web.client.HttpResponse<T>) send().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.web.client.HttpRequest#send} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.web.client.HttpRequest#send}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.web.client.HttpRequest#send} but you don't need to compose it with other operations.
   */
  public void sendAndForget() { 
    send().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param name the header name
   * @param value the header value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> putHeader(String name, java.lang.Iterable<String> value) { 
    delegate.putHeader(name, value);
    return this;
  }

  /**
   * @param credentials the credentials to use.
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.HttpRequest<T> authentication(io.vertx.ext.auth.authentication.Credentials credentials) { 
    delegate.authentication(credentials);
    return this;
  }

  private io.vertx.mutiny.core.MultiMap cached_0;
  public static <T>HttpRequest<T> newInstance(io.vertx.ext.web.client.HttpRequest arg) {
    return arg != null ? new HttpRequest<T>(arg) : null;
  }


  public static <T>HttpRequest<T> newInstance(io.vertx.ext.web.client.HttpRequest arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new HttpRequest<T>(arg, __typeArg_T) : null;
  }

}
