/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.sqlclient;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.mutiny.sqlclient.PreparedStatement;
import io.vertx.mutiny.sqlclient.SqlClient;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.sqlclient.Transaction.class)
public class Transaction
extends SqlClient {
    public static final TypeArg<Transaction> __TYPE_ARG = new TypeArg(obj -> new Transaction((io.vertx.sqlclient.Transaction)obj), Transaction::getDelegate);
    private final io.vertx.sqlclient.Transaction delegate;

    public Transaction(io.vertx.sqlclient.Transaction delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    Transaction() {
        super(null);
        this.delegate = null;
    }

    public io.vertx.sqlclient.Transaction getDelegate() {
        return this.delegate;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    private Transaction __prepare(String sql, final Handler<AsyncResult<PreparedStatement>> handler) {
        this.delegate.prepare(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.PreparedStatement>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.PreparedStatement> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<PreparedStatement> prepare(String sql) {
        return AsyncResultUni.toUni(handler -> this.__prepare(sql, (Handler<AsyncResult<PreparedStatement>>)handler));
    }

    public PreparedStatement prepareAndAwait(String sql) {
        return (PreparedStatement)this.prepare(sql).await().indefinitely();
    }

    private void __commit(Handler<AsyncResult<Void>> handler) {
        this.delegate.commit(handler);
    }

    public Uni<Void> commit() {
        return AsyncResultUni.toUni(handler -> this.__commit((Handler<AsyncResult<Void>>)handler));
    }

    public Void commitAndAwait() {
        return (Void)this.commit().await().indefinitely();
    }

    private void __rollback(Handler<AsyncResult<Void>> handler) {
        this.delegate.rollback(handler);
    }

    public Uni<Void> rollback() {
        return AsyncResultUni.toUni(handler -> this.__rollback((Handler<AsyncResult<Void>>)handler));
    }

    public Void rollbackAndAwait() {
        return (Void)this.rollback().await().indefinitely();
    }

    private Transaction __abortHandler(Handler<Void> handler) {
        this.delegate.abortHandler(handler);
        return this;
    }

    public Transaction abortHandler(Consumer<Void> handler) {
        return this.__abortHandler(handler != null ? handler::accept : null);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public void commitAndForget() {
        this.delegate.commit();
    }

    public void rollbackAndForget() {
        this.delegate.rollback();
    }

    public static Transaction newInstance(io.vertx.sqlclient.Transaction arg) {
        return arg != null ? new Transaction(arg) : null;
    }
}

