/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.shell.command;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mutiny.ext.shell.command.Command;
import io.vertx.mutiny.ext.shell.command.CommandResolver;
import java.util.List;
import java.util.stream.Collectors;

@MutinyGen(value=io.vertx.ext.shell.command.CommandRegistry.class)
public class CommandRegistry
extends CommandResolver {
    public static final TypeArg<CommandRegistry> __TYPE_ARG = new TypeArg(obj -> new CommandRegistry((io.vertx.ext.shell.command.CommandRegistry)obj), CommandRegistry::getDelegate);
    private final io.vertx.ext.shell.command.CommandRegistry delegate;

    public CommandRegistry(io.vertx.ext.shell.command.CommandRegistry delegate) {
        super((io.vertx.ext.shell.command.CommandResolver)delegate);
        this.delegate = delegate;
    }

    public CommandRegistry(Object delegate) {
        super((io.vertx.ext.shell.command.CommandResolver)((io.vertx.ext.shell.command.CommandRegistry)delegate));
        this.delegate = (io.vertx.ext.shell.command.CommandRegistry)delegate;
    }

    CommandRegistry() {
        super(null);
        this.delegate = null;
    }

    public io.vertx.ext.shell.command.CommandRegistry getDelegate() {
        return this.delegate;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandRegistry that = (CommandRegistry)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static CommandRegistry getShared(io.vertx.mutiny.core.Vertx vertx) {
        CommandRegistry ret = CommandRegistry.newInstance(io.vertx.ext.shell.command.CommandRegistry.getShared((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CommandRegistry create(io.vertx.mutiny.core.Vertx vertx) {
        CommandRegistry ret = CommandRegistry.newInstance(io.vertx.ext.shell.command.CommandRegistry.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    @CheckReturnValue
    public Uni<Command> registerCommand(Command command) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.registerCommand(command.getDelegate(), (Handler)new DelegatingHandler(completionHandler, ar -> ar.map(event -> Command.newInstance(event)))));
    }

    public Command registerCommandAndAwait(Command command) {
        return (Command)this.registerCommand(command).await().indefinitely();
    }

    @Fluent
    public CommandRegistry registerCommandAndForget(Command command) {
        this.registerCommand(command).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<Command>> registerCommands(List<Command> commands) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.registerCommands(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new DelegatingHandler(completionHandler, ar -> ar.map(event -> event.stream().map(elt -> Command.newInstance(elt)).collect(Collectors.toList())))));
    }

    public List<Command> registerCommandsAndAwait(List<Command> commands) {
        return (List)this.registerCommands(commands).await().indefinitely();
    }

    @Fluent
    public CommandRegistry registerCommandsAndForget(List<Command> commands) {
        this.registerCommands(commands).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> unregisterCommand(String commandName) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.unregisterCommand(commandName, completionHandler));
    }

    public Void unregisterCommandAndAwait(String commandName) {
        return (Void)this.unregisterCommand(commandName).await().indefinitely();
    }

    @Fluent
    public CommandRegistry unregisterCommandAndForget(String commandName) {
        this.unregisterCommand(commandName).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public static CommandRegistry newInstance(io.vertx.ext.shell.command.CommandRegistry arg) {
        return arg != null ? new CommandRegistry(arg) : null;
    }
}

