/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.internal;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import mutiny.zero.internal.AlreadyCompletedSubscription;
import mutiny.zero.internal.IteratorSubscription;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class GeneratorPublisher<S, T>
implements Publisher<T> {
    private final Supplier<S> stateSupplier;
    private final Function<S, Iterator<T>> generator;

    public GeneratorPublisher(Supplier<S> stateSupplier, Function<S, Iterator<T>> generator) {
        this.stateSupplier = stateSupplier;
        this.generator = generator;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber cannot be null");
        Iterator<T> iterator = this.generator.apply(this.stateSupplier.get());
        if (iterator == null) {
            subscriber.onSubscribe((Subscription)new AlreadyCompletedSubscription());
            subscriber.onError((Throwable)new IllegalArgumentException("The generator cannot produce a null iterator"));
        } else if (!iterator.hasNext()) {
            subscriber.onSubscribe((Subscription)new AlreadyCompletedSubscription());
            subscriber.onComplete();
        } else {
            subscriber.onSubscribe(new IteratorSubscription<T>(iterator, subscriber));
        }
    }
}

