/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.math;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.math.Statistic;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class StatisticsOperator<T extends Number>
implements Function<Multi<T>, Multi<Statistic<T>>> {
    private final Statistic<T> EMPTY = new Statistic<Object>(0L, 0.0, 0.0, 0.0, 0.0, null, null);
    private final AtomicReference<Statistic<T>> currentStatistic = new AtomicReference<Statistic<T>>(this.EMPTY);

    @Override
    public Multi<Statistic<T>> apply(Multi<T> multi) {
        return multi.onItem().transform(x$0 -> this.push((Number)x$0)).onCompletion().ifEmpty().continueWith((Object[])new Statistic[]{this.EMPTY});
    }

    private Statistic<T> push(T number) {
        return this.currentStatistic.updateAndGet(stat -> {
            long n1 = stat.n;
            long n = stat.n + 1L;
            double m1 = stat.m1;
            double m2 = stat.m2;
            double m3 = stat.m3;
            double m4 = stat.m4;
            Number min = (Number)stat.min;
            Number max = (Number)stat.max;
            double delta = number.doubleValue() - stat.m1;
            double delta_n = delta / (double)n;
            double delta_n2 = delta_n * delta_n;
            double term1 = delta * delta_n * (double)n1;
            m1 += delta_n;
            m4 += term1 * delta_n2 * (double)(n * n - 3L * n + 3L) + 6.0 * delta_n2 * m2 - 4.0 * delta_n * m3;
            m3 += term1 * delta_n * (double)(n - 2L) - 3.0 * delta_n * m2;
            m2 += term1;
            if (min == null || ((Comparable)((Object)min)).compareTo(number) > 0) {
                min = number;
            }
            if (max == null || ((Comparable)((Object)max)).compareTo(number) < 0) {
                max = number;
            }
            return new Statistic<Number>(n, m1, m2, m3, m4, min, max);
        });
    }
}

