/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.math;

import io.smallrye.mutiny.Multi;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class OccurrenceOperator<T>
implements Function<Multi<T>, Multi<Map<T, Long>>> {
    private final ConcurrentHashMap<T, Long> occurrences = new ConcurrentHashMap();

    @Override
    public Multi<Map<T, Long>> apply(Multi<T> multi) {
        return multi.onTermination().invoke(this.occurrences::clear).onItem().transform(item -> {
            this.occurrences.compute(item, (it, c) -> c == null ? 1L : c + 1L);
            return new HashMap<T, Long>(this.occurrences);
        }).onCompletion().ifEmpty().continueWith((Object[])new Map[]{Collections.emptyMap()});
    }
}

