/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import io.smallrye.common.process.LineProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;

final class QueueReader
extends BufferedReader {
    private final ArrayBlockingQueue<Object> q = new ArrayBlockingQueue(16);
    private volatile boolean closed;
    private boolean eof;
    private String current;
    private int offset;

    QueueReader() {
        super(QueueReader.nullReader());
    }

    private void check() throws IOException {
        if (this.closed) {
            throw new IOException("Reader is closed");
        }
    }

    private void fill() throws IOException {
        Object val;
        if (this.eof) {
            return;
        }
        try {
            val = this.q.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("Thread interrupted while reading");
        }
        if (val instanceof String) {
            String s;
            this.current = s = (String)val;
        } else if (val == LineProcessor.EOF) {
            this.eof = true;
        } else {
            if (val instanceof IOException) {
                IOException e = (IOException)val;
                this.closed = true;
                this.q.clear();
                throw new IOException(e);
            }
            throw new IllegalStateException();
        }
    }

    @Override
    public int read() throws IOException {
        this.check();
        if (this.current == null) {
            this.fill();
            if (this.eof) {
                return -1;
            }
        }
        if (this.current.length() < this.offset) {
            return this.current.charAt(this.offset++);
        }
        this.current = null;
        this.offset = 0;
        return 10;
    }

    @Override
    public int read(char[] array, int off, int len) throws IOException {
        Objects.checkFromIndexSize(off, len, array.length);
        this.check();
        for (int i = 0; i < len; ++i) {
            int res = this.read();
            if (res == -1) {
                return i == 0 ? -1 : i;
            }
            array[off + i] = (char)res;
        }
        return len;
    }

    @Override
    public String readLine() throws IOException {
        this.check();
        if (this.current == null) {
            this.fill();
            if (this.eof) {
                return null;
            }
        }
        String current = this.current;
        this.current = null;
        return this.offset == 0 ? current : current.substring(this.offset);
    }

    @Override
    public long skip(long n) throws IOException {
        this.check();
        long cnt = 0L;
        while (cnt < n) {
            if (this.current == null) {
                this.fill();
            }
            if (this.eof) break;
            int amt = this.current.length() - this.offset + 1;
            if (n - cnt >= (long)amt) {
                this.current = null;
                cnt += (long)amt;
                continue;
            }
            this.offset += amt;
        }
        return cnt;
    }

    @Override
    public boolean ready() throws IOException {
        this.check();
        return this.eof || this.current != null;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark() not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    @Override
    public void close() {
        this.closed = true;
        this.q.clear();
    }

    void handleLine(Object obj) {
        if (!this.closed) {
            this.q.add(obj);
            if (this.closed) {
                this.q.clear();
            }
        }
    }
}

