/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import io.smallrye.common.os.OS;
import io.smallrye.common.process.ProcessExecutionException;
import java.util.List;

public class AbnormalExitException
extends ProcessExecutionException {
    private static final long serialVersionUID = -2058346021193103167L;
    private int exitCode = -1;
    private boolean softTimeoutElapsed;
    private boolean hardTimeoutElapsed;
    private List<String> errorOutput = List.of();

    public AbnormalExitException() {
    }

    public AbnormalExitException(String msg) {
        super(msg);
    }

    public AbnormalExitException(Throwable cause) {
        super(cause);
    }

    public AbnormalExitException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public int exitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public boolean softTimeoutElapsed() {
        return this.softTimeoutElapsed;
    }

    public void setSoftTimeoutElapsed(boolean softTimeoutElapsed) {
        this.softTimeoutElapsed = softTimeoutElapsed;
    }

    public boolean hardTimeoutElapsed() {
        return this.hardTimeoutElapsed;
    }

    public void setHardTimeoutElapsed(boolean hardTimeoutElapsed) {
        this.hardTimeoutElapsed = hardTimeoutElapsed;
    }

    public List<String> errorOutput() {
        return this.errorOutput;
    }

    public void setErrorOutput(List<String> errorOutput) {
        this.errorOutput = List.copyOf(errorOutput);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append(" with exit code ").append(this.exitCode);
        if (OS.current() != OS.WINDOWS && this.exitCode > 128 && this.exitCode <= 192) {
            b.append(" (possibly due to signal ").append(this.exitCode - 128).append(')');
        }
        if (this.softTimeoutElapsed) {
            if (this.hardTimeoutElapsed) {
                b.append(" after soft and hard timeouts elapsed");
            } else {
                b.append(" after soft timeout elapsed");
            }
        } else if (this.hardTimeoutElapsed) {
            b.append(" after hard timeout elapsed");
        }
        List<String> errorOutput = this.errorOutput;
        if (!errorOutput.isEmpty()) {
            b.append(" with error output:");
            for (String line : errorOutput) {
                b.append("\n > ").append(line);
            }
        }
        return b;
    }
}

