package io.smallrye.common.constraint;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.lang.Object;
import java.lang.String;
import java.util.Arrays;
import java.lang.ArrayIndexOutOfBoundsException;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;

/**
 * Warning this class consists of generated code.
 */
public class Messages_$bundle implements Messages, Serializable {
    private static final long serialVersionUID = 1L;
    protected Messages_$bundle() {}
    public static final Messages_$bundle INSTANCE = new Messages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String nullParam$str() {
        return "Parameter '%s' may not be null";
    }
    @Override
    public final IllegalArgumentException nullParam(final String paramName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullParam$str(), paramName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String paramLessThan$str() {
        return "SRCOM00001: Parameter '%s' may not be less than %s";
    }
    @Override
    public final IllegalArgumentException paramLessThan(final String name, final long min) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramLessThan$str(), name, min));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final IllegalArgumentException paramLessThan(final String name, final double min) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramLessThan$str(), name, min));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final IllegalArgumentException paramLessThan(final String name, final Object min) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramLessThan$str(), name, min));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String paramGreaterThan$str() {
        return "SRCOM00002: Parameter '%s' may not be greater than than %s";
    }
    @Override
    public final IllegalArgumentException paramGreaterThan(final String name, final long max) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramGreaterThan$str(), name, max));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final IllegalArgumentException paramGreaterThan(final String name, final double max) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramGreaterThan$str(), name, max));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final IllegalArgumentException paramGreaterThan(final String name, final Object max) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramGreaterThan$str(), name, max));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String arrayOffsetGreaterThanLength$str() {
        return "SRCOM00003: Given offset of %d is greater than array length of %d";
    }
    @Override
    public final ArrayIndexOutOfBoundsException arrayOffsetGreaterThanLength(final int offs, final int arrayLength) {
        final ArrayIndexOutOfBoundsException result = new ArrayIndexOutOfBoundsException(String.format(getLoggingLocale(), arrayOffsetGreaterThanLength$str(), offs, arrayLength));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String arrayOffsetLengthGreaterThanLength$str() {
        return "SRCOM00004: Given offset of %d plus length of %d is greater than array length of %d";
    }
    @Override
    public final ArrayIndexOutOfBoundsException arrayOffsetLengthGreaterThanLength(final int offs, final int len, final int arrayLength) {
        final ArrayIndexOutOfBoundsException result = new ArrayIndexOutOfBoundsException(String.format(getLoggingLocale(), arrayOffsetLengthGreaterThanLength$str(), offs, len, arrayLength));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullArrayParam$str() {
        return "SRCOM00005: Array index %d of parameter '%s' may not be null";
    }
    @Override
    public final IllegalArgumentException nullArrayParam(final int index, final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullArrayParam$str(), index, name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String emptyParam$str() {
        return "SRCOM00006: Parameter '%s' must not be empty";
    }
    @Override
    public final IllegalArgumentException emptyParam(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), emptyParam$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedNullValue$str() {
        return "SRCOM00007: Internal error: Assertion failure: Unexpectedly null value";
    }
    @Override
    public final String unexpectedNullValue() {
        return String.format(getLoggingLocale(), unexpectedNullValue$str());
    }
    protected String expectedLockHold$str() {
        return "SRCOM00008: Internal error: Assertion failure: Current thread expected to hold lock for %s";
    }
    @Override
    public final String expectedLockHold(final Object monitor) {
        return String.format(getLoggingLocale(), expectedLockHold$str(), monitor);
    }
    protected String expectedLockNotHold$str() {
        return "SRCOM00009: Internal error: Assertion failure: Current thread expected to not hold lock for %s";
    }
    @Override
    public final String expectedLockNotHold(final Object monitor) {
        return String.format(getLoggingLocale(), expectedLockNotHold$str(), monitor);
    }
    protected String expectedBoolean$str() {
        return "SRCOM00010: Internal error: Assertion failure: Expected boolean value to be %s";
    }
    @Override
    public final String expectedBoolean(final boolean expr) {
        return String.format(getLoggingLocale(), expectedBoolean$str(), expr);
    }
    protected String unreachableCode$str() {
        return "SRCOM00011: Internal error: Unreachable code has been reached";
    }
    @Override
    public final IllegalStateException unreachableCode() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unreachableCode$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String impossibleSwitchCase$str() {
        return "SRCOM00012: Internal error: Impossible switch condition encountered: %s";
    }
    @Override
    public final IllegalStateException impossibleSwitchCase(final Object cond) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), impossibleSwitchCase$str(), cond));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupported$str() {
        return "SRCOM00013: Method \"%s\" of class \"%s\" is not supported";
    }
    @Override
    public final UnsupportedOperationException unsupported(final String methodName, final String className) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unsupported$str(), methodName, className));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
