package io.slugstack.publishingplugin.github

import org.gradle.api.DefaultTask
import org.gradle.api.tasks.TaskAction

/**
 * Initializes a dependabot.yml file within the .github/ folder in a repository root.
 */
class InitGithubDependabotTask extends DefaultTask {

    @TaskAction
    void initGithubDependabot() {
        File dependabotYml = project.file('.github/dependabot.yml')
        if (!dependabotYml.exists()) {
            dependabotYml.parentFile.mkdirs()
            dependabotYml << getClass().getResourceAsStream('/github/dependabot.yml').text
        }

    }
}
