/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.dataflowengine.semanticsloader;

import io.shiftleft.dataflowengine.semanticsloader.Semantic;
import io.shiftleft.dataflowengine.semanticsloader.Semantics;
import io.shiftleft.dataflowengine.semanticsloader.SemanticsLoader$;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001M;Qa\u0003\u0007\t\u0002U1Qa\u0006\u0007\t\u0002aAQaH\u0001\u0005\u0002\u0001BQ!I\u0001\u0005\u0002\t2Aa\u0006\u0007\u0001M!Aq\u0005\u0002B\u0001B\u0003%\u0001\u0006C\u0003 \t\u0011\u00051\u0007C\u00047\t\t\u0007I\u0011B\u001c\t\r\u0011#\u0001\u0015!\u00039\u0011\u0015)E\u0001\"\u0001G\u0011\u00159E\u0001\"\u0003I\u0003=\u0019V-\\1oi&\u001c7\u000fT8bI\u0016\u0014(BA\u0007\u000f\u0003=\u0019X-\\1oi&\u001c7\u000f\\8bI\u0016\u0014(BA\b\u0011\u00039!\u0017\r^1gY><XM\\4j]\u0016T!!\u0005\n\u0002\u0013MD\u0017N\u001a;mK\u001a$(\"A\n\u0002\u0005%|7\u0001\u0001\t\u0003-\u0005i\u0011\u0001\u0004\u0002\u0010'\u0016l\u0017M\u001c;jGNdu.\u00193feN\u0011\u0011!\u0007\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005)\u0012AD3naRL8+Z7b]RL7m]\u000b\u0002GA\u0011a\u0003J\u0005\u0003K1\u0011\u0011bU3nC:$\u0018nY:\u0014\u0005\u0011I\u0012\u0001\u00034jY\u0016t\u0017-\\3\u0011\u0005%\u0002dB\u0001\u0016/!\tY3$D\u0001-\u0015\tiC#\u0001\u0004=e>|GOP\u0005\u0003_m\ta\u0001\u0015:fI\u00164\u0017BA\u00193\u0005\u0019\u0019FO]5oO*\u0011qf\u0007\u000b\u0003iU\u0002\"A\u0006\u0003\t\u000b\u001d2\u0001\u0019\u0001\u0015\u0002\r1|wmZ3s+\u0005A\u0004CA\u001dC\u001b\u0005Q$BA\u001e=\u0003\u0015awn\u001a\u001bk\u0015\tid(A\u0004m_\u001e<\u0017N\\4\u000b\u0005}\u0002\u0015AB1qC\u000eDWMC\u0001B\u0003\ry'oZ\u0005\u0003\u0007j\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0005Y>\fG\rF\u0001$\u00039awn\u001a$pe6\fG/\u0012:s_J$2!\u0013'O!\tQ\"*\u0003\u0002L7\t!QK\\5u\u0011\u0015i%\u00021\u0001)\u0003\ri7o\u001a\u0005\u0006\u001f*\u0001\r\u0001U\u0001\u000bY&tWMT;nE\u0016\u0014\bC\u0001\u000eR\u0013\t\u00116DA\u0002J]R\u0004")
public class SemanticsLoader {
    private final String filename;
    private final Logger logger;

    public static Semantics emptySemantics() {
        return SemanticsLoader$.MODULE$.emptySemantics();
    }

    private Logger logger() {
        return this.logger;
    }

    public Semantics load() {
        Semantics semantics;
        IntRef lineNumber = IntRef.create((int)0);
        try (BufferedSource bufferedReader = Source$.MODULE$.fromFile(this.filename, Codec$.MODULE$.fallbackSystemCodec());){
            List semanticElements = bufferedReader.getLines().flatMap((Function1 & Serializable & scala.Serializable)line -> {
                Iterable iterable;
                String[] parts = line.split(",");
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).size() == 2) {
                    try {
                        String methodFullName = parts[0].trim();
                        int parameterIndex = new StringOps(Predef$.MODULE$.augmentString(parts[1].trim())).toInt();
                        ++lineNumber$1.elem;
                        iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Semantic(methodFullName, parameterIndex)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logFormatError("Argument index is not convertable to Int.", lineNumber$1.elem);
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                } else {
                    this.logFormatError("Invalid number of elements per line. Expected method name followed by argument index.", lineNumber$1.elem);
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }).toList();
            semantics = new Semantics((List<Semantic>)semanticElements);
        }
        return semantics;
    }

    private void logFormatError(String msg, int lineNumber) {
        this.logger().warn(new StringBuilder(13).append(msg).append(" In ").append(this.filename).append(" on line ").append(lineNumber).toString());
    }

    public SemanticsLoader(String filename) {
        this.filename = filename;
        this.logger = LogManager.getLogger(this.getClass());
    }
}

