/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.tracing;

import io.sentry.IScopes;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ITransaction;
import io.sentry.ScopesAdapter;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.spring.tracing.SentryTransaction;
import io.sentry.util.Objects;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

@ApiStatus.Internal
public class SentryTransactionAdvice
implements MethodInterceptor {
    private static final String TRACE_ORIGIN = "auto.function.spring.advice";
    @NotNull
    private final IScopes scopesBeforeForking;

    public SentryTransactionAdvice() {
        this((IScopes)ScopesAdapter.getInstance());
    }

    public SentryTransactionAdvice(@NotNull IScopes scopes) {
        this.scopesBeforeForking = (IScopes)Objects.requireNonNull((Object)scopes, (String)"scopes are required");
    }

    /*
     * Loose catch block
     */
    public Object invoke(@NotNull MethodInvocation invocation) throws Throwable {
        Method mostSpecificMethod = AopUtils.getMostSpecificMethod((Method)invocation.getMethod(), invocation.getThis().getClass());
        @Nullable SentryTransaction sentryTransaction = (SentryTransaction)AnnotationUtils.findAnnotation((Method)mostSpecificMethod, SentryTransaction.class);
        if (sentryTransaction == null) {
            sentryTransaction = (SentryTransaction)AnnotationUtils.findAnnotation(mostSpecificMethod.getDeclaringClass(), SentryTransaction.class);
        }
        TransactionNameAndSource nameAndSource = this.resolveTransactionName(invocation, sentryTransaction);
        boolean isTransactionActive = this.isTransactionActive(this.scopesBeforeForking);
        if (isTransactionActive) {
            return invocation.proceed();
        }
        String operation = sentryTransaction != null && !StringUtils.isEmpty((Object)sentryTransaction.operation()) ? sentryTransaction.operation() : "bean";
        @NotNull IScopes forkedScopes = this.scopesBeforeForking.forkedScopes("SentryTransactionAdvice");
        try (@NotNull ISentryLifecycleToken ignored = forkedScopes.makeCurrent();){
            TransactionOptions transactionOptions = new TransactionOptions();
            transactionOptions.setBindToScope(true);
            transactionOptions.setOrigin(TRACE_ORIGIN);
            ITransaction transaction = forkedScopes.startTransaction(new TransactionContext(nameAndSource.name, nameAndSource.source, operation), transactionOptions);
            try {
                Object result = invocation.proceed();
                transaction.setStatus(SpanStatus.OK);
                Object object = result;
                return object;
            }
            catch (Throwable e) {
                transaction.setStatus(SpanStatus.INTERNAL_ERROR);
                transaction.setThrowable(e);
                throw e;
            }
            finally {
                transaction.finish();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    @NotNull
    private TransactionNameAndSource resolveTransactionName(MethodInvocation invocation, @Nullable SentryTransaction sentryTransaction) {
        if (sentryTransaction == null || StringUtils.isEmpty((Object)sentryTransaction.value())) {
            String name = invocation.getMethod().getDeclaringClass().getSimpleName() + "." + invocation.getMethod().getName();
            return new TransactionNameAndSource(name, TransactionNameSource.COMPONENT);
        }
        return new TransactionNameAndSource(sentryTransaction.value(), TransactionNameSource.CUSTOM);
    }

    private boolean isTransactionActive(@NotNull IScopes scopes) {
        return scopes.getSpan() != null;
    }

    private static class TransactionNameAndSource {
        @NotNull
        private final String name;
        @NotNull
        private final TransactionNameSource source;

        public TransactionNameAndSource(@NotNull String name, @NotNull TransactionNameSource source) {
            this.name = name;
            this.source = source;
        }
    }
}

