/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.IContinuousProfiler;
import io.sentry.IProfileConverter;
import io.sentry.Sentry;
import io.sentry.SentryOptions;
import io.sentry.util.InitUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class SentryProfilerConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"sentryOpenTelemetryProfilerConfiguration"})
    public IContinuousProfiler sentryOpenTelemetryProfilerConfiguration() {
        SentryOptions options = Sentry.getGlobalScope().getOptions();
        if (Sentry.isEnabled()) {
            return InitUtil.initializeProfiler((SentryOptions)options);
        }
        return options.getContinuousProfiler();
    }

    @Bean
    @ConditionalOnMissingBean(name={"sentryOpenTelemetryProfilerConverterConfiguration"})
    public IProfileConverter sentryOpenTelemetryProfilerConverterConfiguration() {
        SentryOptions options = Sentry.getGlobalScope().getOptions();
        if (Sentry.isEnabled()) {
            return InitUtil.initializeProfileConverter((SentryOptions)options);
        }
        return options.getProfilerConverter();
    }
}

