/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.exception;

import io.sentry.IScopes;
import io.sentry.ScopesAdapter;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.protocol.Mechanism;
import io.sentry.spring.exception.SentryCaptureExceptionParameter;
import io.sentry.util.Objects;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;

@ApiStatus.Internal
public class SentryCaptureExceptionParameterAdvice
implements MethodInterceptor {
    private static final String MECHANISM_TYPE = "SentrySpring5CaptureExceptionParameterAdvice";
    @NotNull
    private final IScopes scopes;

    public SentryCaptureExceptionParameterAdvice() {
        this((IScopes)ScopesAdapter.getInstance());
    }

    public SentryCaptureExceptionParameterAdvice(@NotNull IScopes scopes) {
        this.scopes = (IScopes)Objects.requireNonNull((Object)scopes, (String)"scopes are required");
    }

    public Object invoke(@NotNull MethodInvocation invocation) throws Throwable {
        Method mostSpecificMethod = AopUtils.getMostSpecificMethod((Method)invocation.getMethod(), invocation.getThis().getClass());
        SentryCaptureExceptionParameter sentryCaptureExceptionParameter = (SentryCaptureExceptionParameter)AnnotationUtils.findAnnotation((Method)mostSpecificMethod, SentryCaptureExceptionParameter.class);
        if (sentryCaptureExceptionParameter != null) {
            Object[] args;
            for (Object arg : args = invocation.getArguments()) {
                if (!(arg instanceof Exception)) continue;
                this.captureException((Exception)arg);
                break;
            }
        }
        return invocation.proceed();
    }

    private void captureException(@NotNull Throwable throwable) {
        Mechanism mechanism = new Mechanism();
        mechanism.setType(MECHANISM_TYPE);
        mechanism.setHandled(Boolean.valueOf(true));
        ExceptionMechanismException mechanismException = new ExceptionMechanismException(mechanism, throwable, Thread.currentThread());
        this.scopes.captureException((Throwable)mechanismException);
    }
}

