/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.tracing;

import io.sentry.BaggageHeader;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanStatus;
import io.sentry.TracingOrigins;
import io.sentry.util.Objects;
import java.net.URI;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class SentrySpanClientWebRequestFilter
implements ExchangeFilterFunction {
    @NotNull
    private final IHub hub;

    public SentrySpanClientWebRequestFilter(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
    }

    @NotNull
    public Mono<ClientResponse> filter(@NotNull ClientRequest request, @NotNull ExchangeFunction next) {
        ISpan activeSpan = this.hub.getSpan();
        if (activeSpan == null) {
            this.addBreadcrumb(request, null);
            return next.exchange(request);
        }
        ISpan span = activeSpan.startChild("http.client");
        span.setDescription(request.method().name() + " " + request.url());
        SentryTraceHeader sentryTraceHeader = span.toSentryTrace();
        @Nullable BaggageHeader baggageHeader = span.toBaggageHeader();
        ClientRequest.Builder requestBuilder = ClientRequest.from((ClientRequest)request);
        if (TracingOrigins.contain((List)this.hub.getOptions().getTracingOrigins(), (URI)request.url())) {
            requestBuilder.header(sentryTraceHeader.getName(), new String[]{sentryTraceHeader.getValue()});
            if (baggageHeader != null) {
                requestBuilder.header(baggageHeader.getName(), new String[]{baggageHeader.getValue()});
            }
        }
        ClientRequest clientRequestWithSentryTraceHeader = requestBuilder.build();
        return next.exchange(clientRequestWithSentryTraceHeader).flatMap(response -> {
            span.setStatus(SpanStatus.fromHttpStatusCode((int)response.rawStatusCode()));
            this.addBreadcrumb(request, (ClientResponse)response);
            span.finish();
            return Mono.just((Object)response);
        }).onErrorMap(throwable -> {
            span.setThrowable(throwable);
            span.setStatus(SpanStatus.INTERNAL_ERROR);
            this.addBreadcrumb(request, null);
            span.finish();
            return throwable;
        });
    }

    private void addBreadcrumb(@NotNull ClientRequest request, @Nullable ClientResponse response) {
        Breadcrumb breadcrumb = Breadcrumb.http((String)request.url().toString(), (String)request.method().name(), response != null ? Integer.valueOf(response.rawStatusCode()) : null);
        Hint hint = new Hint();
        hint.set("springExchangeFilter:request", (Object)request);
        if (response != null) {
            hint.set("springExchangeFilter:response", (Object)response);
        }
        this.hub.addBreadcrumb(breadcrumb, hint);
    }
}

