/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.tracing;

import io.sentry.Breadcrumb;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanStatus;
import io.sentry.TracingOrigins;
import io.sentry.util.Objects;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class SentrySpanClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    @NotNull
    private final IHub hub;

    public SentrySpanClientHttpRequestInterceptor(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ClientHttpResponse intercept(@NotNull HttpRequest request, @NotNull byte[] body, @NotNull ClientHttpRequestExecution execution) throws IOException {
        ISpan span;
        Integer responseStatusCode = null;
        ClientHttpResponse response = null;
        ISpan activeSpan = this.hub.getSpan();
        if (activeSpan == null) {
            ClientHttpResponse clientHttpResponse = execution.execute(request, body);
            this.addBreadcrumb(request, body, responseStatusCode, response);
            return clientHttpResponse;
        }
        {
            catch (Throwable throwable) {
                this.addBreadcrumb(request, body, responseStatusCode, response);
                throw throwable;
            }
            span = activeSpan.startChild("http.client");
            span.setDescription(request.getMethodValue() + " " + request.getURI());
            SentryTraceHeader sentryTraceHeader = span.toSentryTrace();
            if (TracingOrigins.contain((List)this.hub.getOptions().getTracingOrigins(), (URI)request.getURI())) {
                request.getHeaders().add(sentryTraceHeader.getName(), sentryTraceHeader.getValue());
            }
            try {
                response = execution.execute(request, body);
                span.setStatus(SpanStatus.fromHttpStatusCode((int)response.getRawStatusCode()));
                responseStatusCode = response.getRawStatusCode();
                ClientHttpResponse clientHttpResponse = response;
                return clientHttpResponse;
            }
            catch (Throwable e) {}
            {
                span.setThrowable(e);
                span.setStatus(SpanStatus.INTERNAL_ERROR);
                throw e;
            }
        }
        finally {
            span.finish();
        }
    }

    private void addBreadcrumb(@NotNull HttpRequest request, @NotNull byte[] body, @Nullable Integer responseStatusCode, @Nullable ClientHttpResponse response) {
        Breadcrumb breadcrumb = Breadcrumb.http((String)request.getURI().toString(), (String)request.getMethodValue(), (Integer)responseStatusCode);
        breadcrumb.setData("request_body_size", (Object)body.length);
        HashMap<String, Object> hintMap = new HashMap<String, Object>();
        hintMap.put("springRequestInterceptor:request", request);
        hintMap.put("springRequestInterceptor:requestBody", body);
        if (response != null) {
            hintMap.put("springRequestInterceptor:response", response);
        }
        this.hub.addBreadcrumb(breadcrumb, hintMap);
    }
}

