/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.HubAdapter;
import io.sentry.SentryOptions;
import io.sentry.protocol.SdkVersion;
import io.sentry.spring.EnableSentry;
import io.sentry.spring.SentryExceptionResolver;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
public class SentryHubRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(@NotNull AnnotationMetadata importingClassMetadata, @NotNull BeanDefinitionRegistry registry) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableSentry.class.getName()));
        if (annotationAttributes != null && annotationAttributes.containsKey((Object)"dsn")) {
            this.registerSentryOptions(registry, annotationAttributes);
            this.registerSentryHubBean(registry);
            this.registerSentryExceptionResolver(registry, annotationAttributes);
        }
    }

    private void registerSentryOptions(@NotNull BeanDefinitionRegistry registry, @NotNull AnnotationAttributes annotationAttributes) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SentryOptions.class);
        if (registry.containsBeanDefinition("mockTransportFactory")) {
            builder.addPropertyReference("transportFactory", "mockTransportFactory");
        }
        builder.addPropertyValue("dsn", (Object)annotationAttributes.getString("dsn"));
        builder.addPropertyValue("enableExternalConfiguration", (Object)true);
        builder.addPropertyValue("sentryClientName", (Object)"sentry.java.spring");
        builder.addPropertyValue("sdkVersion", (Object)SentryHubRegistrar.createSdkVersion());
        if (annotationAttributes.containsKey((Object)"sendDefaultPii")) {
            builder.addPropertyValue("sendDefaultPii", (Object)annotationAttributes.getBoolean("sendDefaultPii"));
        }
        if (annotationAttributes.containsKey((Object)"maxRequestBodySize")) {
            builder.addPropertyValue("maxRequestBodySize", annotationAttributes.get((Object)"maxRequestBodySize"));
        }
        registry.registerBeanDefinition("sentryOptions", (BeanDefinition)builder.getBeanDefinition());
    }

    private void registerSentryHubBean(@NotNull BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HubAdapter.class);
        builder.setInitMethodName("getInstance");
        registry.registerBeanDefinition("sentryHub", (BeanDefinition)builder.getBeanDefinition());
    }

    private void registerSentryExceptionResolver(@NotNull BeanDefinitionRegistry registry, @NotNull AnnotationAttributes annotationAttributes) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SentryExceptionResolver.class);
        builder.addConstructorArgReference("sentryHub");
        int order = (Integer)annotationAttributes.getNumber("exceptionResolverOrder");
        builder.addConstructorArgValue((Object)order);
        registry.registerBeanDefinition("sentryExceptionResolver", (BeanDefinition)builder.getBeanDefinition());
    }

    @NotNull
    private static SdkVersion createSdkVersion() {
        SentryOptions defaultOptions = new SentryOptions();
        SdkVersion sdkVersion = defaultOptions.getSdkVersion();
        String name = "sentry.java.spring";
        String version = "5.4.2";
        sdkVersion = SdkVersion.updateSdkVersion((SdkVersion)sdkVersion, (String)"sentry.java.spring", (String)"5.4.2");
        sdkVersion.addPackage("maven:io.sentry:sentry-spring", "5.4.2");
        return sdkVersion;
    }
}

