/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.Breadcrumb;
import io.sentry.EventProcessor;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.spring.SentryRequestHttpServletRequestProcessor;
import io.sentry.spring.SentryRequestResolver;
import io.sentry.util.Objects;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.Ordered;

public class SentrySpringRequestListener
implements ServletRequestListener,
Ordered {
    @NotNull
    private final IHub hub;
    @NotNull
    private final SentryRequestResolver requestResolver;

    public SentrySpringRequestListener() {
        this((IHub)HubAdapter.getInstance());
    }

    public SentrySpringRequestListener(@NotNull IHub hub, @NotNull SentryRequestResolver requestResolver) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.requestResolver = (SentryRequestResolver)Objects.requireNonNull((Object)requestResolver, (String)"requestResolver are required");
    }

    SentrySpringRequestListener(@NotNull IHub hub) {
        this(hub, new SentryRequestResolver(hub));
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        this.hub.popScope();
    }

    public void requestInitialized(ServletRequestEvent sre) {
        this.hub.pushScope();
        ServletRequest servletRequest = sre.getServletRequest();
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)sre.getServletRequest();
            this.hub.addBreadcrumb(Breadcrumb.http((String)request.getRequestURI(), (String)request.getMethod()));
            this.hub.configureScope(scope -> {
                scope.setRequest(this.requestResolver.resolveSentryRequest(request));
                scope.addEventProcessor((EventProcessor)new SentryRequestHttpServletRequestProcessor(request));
            });
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

