/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.tracing;

import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanStatus;
import io.sentry.util.Objects;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.NamedThreadLocal;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.util.UriTemplateHandler;

public class SentrySpanClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    @NotNull
    private static final ThreadLocal<Deque<String>> urlTemplate = new UrlTemplateThreadLocal();
    @NotNull
    private final IHub hub;

    public SentrySpanClientHttpRequestInterceptor(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ClientHttpResponse intercept(@NotNull HttpRequest request, @NotNull byte[] body, @NotNull ClientHttpRequestExecution execution) throws IOException {
        ISpan activeSpan = this.hub.getSpan();
        if (activeSpan == null) {
            return execution.execute(request, body);
        }
        ISpan span = activeSpan.startChild("http.client");
        span.setDescription(request.getMethodValue() + " " + SentrySpanClientHttpRequestInterceptor.ensureLeadingSlash(urlTemplate.get().poll()));
        SentryTraceHeader sentryTraceHeader = span.toSentryTrace();
        request.getHeaders().add(sentryTraceHeader.getName(), sentryTraceHeader.getValue());
        try {
            ClientHttpResponse response = execution.execute(request, body);
            span.setStatus(SpanStatus.fromHttpStatusCode((int)response.getRawStatusCode()));
            ClientHttpResponse clientHttpResponse = response;
            return clientHttpResponse;
        }
        finally {
            span.finish();
            if (urlTemplate.get().isEmpty()) {
                urlTemplate.remove();
            }
        }
    }

    @NotNull
    public UriTemplateHandler createUriTemplateHandler(final @NotNull UriTemplateHandler delegate) {
        return new UriTemplateHandler(){

            public URI expand(String url, Map<String, ?> arguments) {
                ((Deque)urlTemplate.get()).push(url);
                return delegate.expand(url, arguments);
            }

            public URI expand(String url, Object ... arguments) {
                ((Deque)urlTemplate.get()).push(url);
                return delegate.expand(url, arguments);
            }
        };
    }

    @NotNull
    private static String ensureLeadingSlash(@Nullable String url) {
        return url == null || url.startsWith("/") ? url : "/" + url;
    }

    private static final class UrlTemplateThreadLocal
    extends NamedThreadLocal<Deque<String>> {
        private UrlTemplateThreadLocal() {
            super("Rest Template URL Template");
        }

        protected Deque<String> initialValue() {
            return new ArrayDeque<String>();
        }
    }
}

