/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.EventProcessor;
import io.sentry.ITransportFactory;
import io.sentry.Sentry;
import io.sentry.SentryOptions;
import io.sentry.spring.SentryUserProvider;
import io.sentry.spring.SentryUserProviderEventProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SentryInitBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    @Nullable
    private ApplicationContext applicationContext;

    public Object postProcessAfterInitialization(@NotNull Object bean, @NotNull String beanName) throws BeansException {
        if (bean instanceof SentryOptions) {
            SentryOptions options = (SentryOptions)bean;
            if (this.applicationContext != null) {
                this.applicationContext.getBeanProvider(SentryUserProvider.class).orderedStream().forEach(sentryUserProvider -> options.addEventProcessor((EventProcessor)new SentryUserProviderEventProcessor(options, (SentryUserProvider)sentryUserProvider)));
                this.applicationContext.getBeanProvider(SentryOptions.TracesSamplerCallback.class).ifAvailable(arg_0 -> ((SentryOptions)options).setTracesSampler(arg_0));
                this.applicationContext.getBeanProvider(ITransportFactory.class).ifAvailable(arg_0 -> ((SentryOptions)options).setTransportFactory(arg_0));
            }
            Sentry.init((SentryOptions)options);
        }
        return bean;
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

