/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.EventProcessor;
import io.sentry.SentryEvent;
import io.sentry.SentryOptions;
import io.sentry.protocol.Request;
import io.sentry.util.Objects;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryRequestHttpServletRequestProcessor
implements EventProcessor {
    private static final List<String> SENSITIVE_HEADERS = Arrays.asList("X-FORWARDED-FOR", "AUTHORIZATION", "COOKIE");
    @NotNull
    private final HttpServletRequest request;
    @NotNull
    private final SentryOptions options;

    public SentryRequestHttpServletRequestProcessor(@NotNull HttpServletRequest request, @NotNull SentryOptions options) {
        this.request = (HttpServletRequest)Objects.requireNonNull((Object)request, (String)"request is required");
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"options are required");
    }

    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @Nullable Object hint) {
        event.setRequest(this.resolveSentryRequest(this.request));
        return event;
    }

    @NotNull
    private Request resolveSentryRequest(@NotNull HttpServletRequest httpRequest) {
        Request sentryRequest = new Request();
        sentryRequest.setMethod(httpRequest.getMethod());
        sentryRequest.setQueryString(httpRequest.getQueryString());
        sentryRequest.setUrl(httpRequest.getRequestURL().toString());
        sentryRequest.setHeaders(this.resolveHeadersMap(httpRequest));
        if (this.options.isSendDefaultPii()) {
            sentryRequest.setCookies(SentryRequestHttpServletRequestProcessor.toString(httpRequest.getHeaders("Cookie")));
        }
        return sentryRequest;
    }

    @NotNull
    private Map<String, String> resolveHeadersMap(@NotNull HttpServletRequest request) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (String headerName : Collections.list(request.getHeaderNames())) {
            if (!this.options.isSendDefaultPii() && SENSITIVE_HEADERS.contains(headerName.toUpperCase())) continue;
            headersMap.put(headerName, SentryRequestHttpServletRequestProcessor.toString(request.getHeaders(headerName)));
        }
        return headersMap;
    }

    @Nullable
    private static String toString(@Nullable Enumeration<String> enumeration) {
        return enumeration != null ? String.join((CharSequence)",", Collections.list(enumeration)) : null;
    }
}

