/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.HubAdapter;
import io.sentry.SentryOptions;
import io.sentry.protocol.SdkVersion;
import io.sentry.spring.EnableSentry;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
public class SentryHubRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableSentry.class.getName()));
        if (annotationAttributes != null && annotationAttributes.containsKey((Object)"dsn")) {
            this.registerSentryOptions(registry, annotationAttributes);
            this.registerSentryHubBean(registry);
        }
    }

    private void registerSentryOptions(BeanDefinitionRegistry registry, AnnotationAttributes annotationAttributes) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SentryOptions.class);
        if (registry.containsBeanDefinition("mockTransport")) {
            builder.addPropertyReference("transport", "mockTransport");
        }
        builder.addPropertyValue("dsn", (Object)annotationAttributes.getString("dsn"));
        builder.addPropertyValue("enableExternalConfiguration", (Object)true);
        builder.addPropertyValue("sentryClientName", (Object)"sentry.java.spring");
        builder.addPropertyValue("sdkVersion", (Object)SentryHubRegistrar.createSdkVersion());
        if (annotationAttributes.containsKey((Object)"sendDefaultPii")) {
            builder.addPropertyValue("sendDefaultPii", (Object)annotationAttributes.getBoolean("sendDefaultPii"));
        }
        registry.registerBeanDefinition("sentryOptions", (BeanDefinition)builder.getBeanDefinition());
    }

    private void registerSentryHubBean(BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HubAdapter.class);
        builder.setInitMethodName("getInstance");
        registry.registerBeanDefinition("sentryHub", (BeanDefinition)builder.getBeanDefinition());
    }

    @NotNull
    private static SdkVersion createSdkVersion() {
        SentryOptions defaultOptions = new SentryOptions();
        SdkVersion sdkVersion = defaultOptions.getSdkVersion();
        if (sdkVersion == null) {
            sdkVersion = new SdkVersion();
        }
        sdkVersion.setName("sentry.java.spring");
        String version = "3.0.0";
        sdkVersion.setVersion("3.0.0");
        sdkVersion.addPackage("maven:sentry-spring", "3.0.0");
        return sdkVersion;
    }
}

