/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.boot;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import io.sentry.logback.SentryAppender;
import io.sentry.spring.boot.SentryProperties;
import io.sentry.util.Objects;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;

class SentryLogbackInitializer
implements GenericApplicationListener {
    @NotNull
    private final SentryProperties sentryProperties;
    @NotNull
    private final List<String> loggers;
    @Nullable
    private SentryAppender sentryAppender;

    public SentryLogbackInitializer(@NotNull SentryProperties sentryProperties) {
        this.sentryProperties = (SentryProperties)((Object)Objects.requireNonNull((Object)((Object)sentryProperties), (String)"properties are required"));
        this.loggers = sentryProperties.getLogging().getLoggers();
    }

    public boolean supportsEventType(@NotNull ResolvableType eventType) {
        return eventType.getRawClass() != null && ContextRefreshedEvent.class.isAssignableFrom(eventType.getRawClass());
    }

    public void onApplicationEvent(@NotNull ApplicationEvent event) {
        this.loggers.forEach(loggerName -> {
            Logger logger = (Logger)LoggerFactory.getLogger((String)loggerName);
            if (!this.isSentryAppenderRegistered(logger)) {
                SentryAppender sentryAppender = this.getSentryAppender();
                Optional.ofNullable(this.sentryProperties.getLogging().getMinimumBreadcrumbLevel()).map(slf4jLevel -> Level.toLevel((String)slf4jLevel.name())).ifPresent(arg_0 -> ((SentryAppender)sentryAppender).setMinimumBreadcrumbLevel(arg_0));
                Optional.ofNullable(this.sentryProperties.getLogging().getMinimumEventLevel()).map(slf4jLevel -> Level.toLevel((String)slf4jLevel.name())).ifPresent(arg_0 -> ((SentryAppender)sentryAppender).setMinimumEventLevel(arg_0));
                sentryAppender.start();
                logger.addAppender((Appender)sentryAppender);
            }
        });
    }

    @NotNull
    private SentryAppender getSentryAppender() {
        if (this.sentryAppender == null) {
            this.sentryAppender = new SentryAppender();
            this.sentryAppender.setName("SENTRY_APPENDER");
            this.sentryAppender.setContext((Context)((LoggerContext)LoggerFactory.getILoggerFactory()));
        }
        return this.sentryAppender;
    }

    private boolean isSentryAppenderRegistered(@NotNull Logger logger) {
        Iterator it = logger.iteratorForAppenders();
        while (it.hasNext()) {
            Appender appender = (Appender)it.next();
            if (!appender.getClass().equals(SentryAppender.class)) continue;
            return true;
        }
        return false;
    }
}

