/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.boot;

import io.sentry.EventProcessor;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ITransportFactory;
import io.sentry.Integration;
import io.sentry.Sentry;
import io.sentry.SentryOptions;
import io.sentry.protocol.SdkVersion;
import io.sentry.spring.SentryExceptionResolver;
import io.sentry.spring.SentryRequestResolver;
import io.sentry.spring.SentrySpringRequestListener;
import io.sentry.spring.SentryUserFilter;
import io.sentry.spring.SentryUserProvider;
import io.sentry.spring.SentryWebConfiguration;
import io.sentry.spring.SpringSecuritySentryUserProvider;
import io.sentry.spring.boot.InAppIncludesResolver;
import io.sentry.spring.boot.SentryProperties;
import io.sentry.spring.boot.SentrySpanRestTemplateCustomizer;
import io.sentry.spring.tracing.SentryAdviceConfiguration;
import io.sentry.spring.tracing.SentrySpanPointcutConfiguration;
import io.sentry.spring.tracing.SentryTracingFilter;
import io.sentry.spring.tracing.SentryTransactionPointcutConfiguration;
import io.sentry.transport.ITransportGate;
import io.sentry.transport.apache.ApacheHttpClientTransportFactory;
import java.util.List;
import java.util.Optional;
import javax.servlet.Filter;
import org.aspectj.lang.ProceedingJoinPoint;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.client.RestTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"sentry.dsn"})
public class SentryAutoConfiguration {

    static final class SentryTracingCondition
    extends AnyNestedCondition {
        public SentryTracingCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={SentryOptions.TracesSamplerCallback.class})
        private static class SentryTracesSamplerBeanCondition {
            private SentryTracesSamplerBeanCondition() {
            }
        }

        @ConditionalOnProperty(name={"sentry.traces-sample-rate"})
        private static class SentryTracesSampleRateCondition {
            private SentryTracesSampleRateCondition() {
            }
        }

        @ConditionalOnProperty(name={"sentry.enable-tracing"}, havingValue="true")
        private static class SentryTracingEnabled {
            private SentryTracingEnabled() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={SentryProperties.class})
    static class HubConfiguration {
        HubConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"sentryOptionsConfiguration"})
        @Order(value=-2147483648)
        @NotNull
        public Sentry.OptionsConfiguration<SentryOptions> sentryOptionsConfiguration(@NotNull ObjectProvider<SentryOptions.BeforeSendCallback> beforeSendCallback, @NotNull ObjectProvider<SentryOptions.BeforeBreadcrumbCallback> beforeBreadcrumbCallback, @NotNull ObjectProvider<SentryOptions.TracesSamplerCallback> tracesSamplerCallback, @NotNull List<EventProcessor> eventProcessors, @NotNull List<Integration> integrations, @NotNull ObjectProvider<ITransportGate> transportGate, @NotNull ObjectProvider<ITransportFactory> transportFactory, @NotNull InAppIncludesResolver inAppPackagesResolver) {
            return options -> {
                beforeSendCallback.ifAvailable(arg_0 -> ((SentryOptions)options).setBeforeSend(arg_0));
                beforeBreadcrumbCallback.ifAvailable(arg_0 -> ((SentryOptions)options).setBeforeBreadcrumb(arg_0));
                tracesSamplerCallback.ifAvailable(arg_0 -> ((SentryOptions)options).setTracesSampler(arg_0));
                eventProcessors.forEach(arg_0 -> ((SentryOptions)options).addEventProcessor(arg_0));
                integrations.forEach(arg_0 -> ((SentryOptions)options).addIntegration(arg_0));
                transportGate.ifAvailable(arg_0 -> ((SentryOptions)options).setTransportGate(arg_0));
                transportFactory.ifAvailable(arg_0 -> ((SentryOptions)options).setTransportFactory(arg_0));
                inAppPackagesResolver.resolveInAppIncludes().forEach(arg_0 -> ((SentryOptions)options).addInAppInclude(arg_0));
            };
        }

        @Bean
        @NotNull
        public InAppIncludesResolver inAppPackagesResolver() {
            return new InAppIncludesResolver();
        }

        @Bean
        @NotNull
        public IHub sentryHub(@NotNull List<Sentry.OptionsConfiguration<SentryOptions>> optionsConfigurations, @NotNull SentryProperties options, @NotNull ObjectProvider<GitProperties> gitProperties) {
            optionsConfigurations.forEach(optionsConfiguration -> optionsConfiguration.configure((SentryOptions)options));
            gitProperties.ifAvailable(git -> {
                if (options.getRelease() == null && options.isUseGitCommitIdAsRelease()) {
                    options.setRelease(git.getCommitId());
                }
            });
            options.setSentryClientName("sentry.java.spring-boot");
            options.setSdkVersion(HubConfiguration.createSdkVersion(options));
            if (options.getTracesSampleRate() == null) {
                options.setTracesSampleRate(0.0);
            }
            options.getIgnoredExceptionsForType().removeIf(it -> !Throwable.class.isAssignableFrom((Class<?>)it));
            Sentry.init((SentryOptions)options);
            return HubAdapter.getInstance();
        }

        @NotNull
        private static SdkVersion createSdkVersion(@NotNull SentryOptions sentryOptions) {
            SdkVersion sdkVersion = sentryOptions.getSdkVersion();
            String name = "sentry.java.spring-boot";
            String version = "5.1.0-beta.2";
            sdkVersion = SdkVersion.updateSdkVersion((SdkVersion)sdkVersion, (String)"sentry.java.spring-boot", (String)"5.1.0-beta.2");
            sdkVersion.addPackage("maven:io.sentry:sentry-spring-boot-starter", "5.1.0-beta.2");
            return sdkVersion;
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnMissingBean(value={ITransportFactory.class})
        @ConditionalOnClass(value={ApacheHttpClientTransportFactory.class})
        static class ApacheHttpClientTransportFactoryAutoconfiguration {
            ApacheHttpClientTransportFactoryAutoconfiguration() {
            }

            @Bean
            @NotNull
            public ApacheHttpClientTransportFactory apacheHttpClientTransportFactory() {
                return new ApacheHttpClientTransportFactory();
            }
        }

        @Configuration(proxyBeanMethods=false)
        @AutoConfigureBefore(value={RestTemplateAutoConfiguration.class})
        @ConditionalOnClass(value={RestTemplate.class})
        static class SentryPerformanceRestTemplateConfiguration {
            SentryPerformanceRestTemplateConfiguration() {
            }

            @Bean
            public SentrySpanRestTemplateCustomizer sentrySpanRestTemplateCustomizer(IHub hub) {
                return new SentrySpanRestTemplateCustomizer(hub);
            }
        }

        @Configuration(proxyBeanMethods=false)
        @Conditional(value={SentryTracingCondition.class})
        @ConditionalOnClass(value={ProceedingJoinPoint.class})
        @Import(value={SentryAdviceConfiguration.class})
        static class SentryPerformanceAspectsConfiguration {
            SentryPerformanceAspectsConfiguration() {
            }

            @Configuration(proxyBeanMethods=false)
            @ConditionalOnMissingBean(name={"sentrySpanPointcut"})
            @Import(value={SentrySpanPointcutConfiguration.class})
            static class SentrySpanPointcutAutoConfiguration {
                SentrySpanPointcutAutoConfiguration() {
                }
            }

            @Configuration(proxyBeanMethods=false)
            @ConditionalOnMissingBean(name={"sentryTransactionPointcut"})
            @Import(value={SentryTransactionPointcutConfiguration.class})
            static class SentryTransactionPointcutAutoConfiguration {
                SentryTransactionPointcutAutoConfiguration() {
                }
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
        @Import(value={SentryWebConfiguration.class})
        static class SentryWebMvcConfiguration {
            SentryWebMvcConfiguration() {
            }

            @Bean
            @ConditionalOnBean(value={SentryUserProvider.class})
            @NotNull
            public FilterRegistrationBean<SentryUserFilter> sentryUserFilter(@NotNull IHub hub, @NotNull SentryProperties sentryProperties, @NotNull List<SentryUserProvider> sentryUserProvider) {
                FilterRegistrationBean filter = new FilterRegistrationBean();
                filter.setFilter((Filter)new SentryUserFilter(hub, sentryUserProvider));
                filter.setOrder(this.resolveUserFilterOrder(sentryProperties).intValue());
                return filter;
            }

            @NotNull
            private Integer resolveUserFilterOrder(@NotNull SentryProperties sentryProperties) {
                return Optional.ofNullable(sentryProperties.getUserFilterOrder()).orElse(Integer.MAX_VALUE);
            }

            @Bean
            @NotNull
            public SentryRequestResolver sentryRequestResolver(@NotNull IHub hub) {
                return new SentryRequestResolver(hub);
            }

            @Bean
            @NotNull
            public SentrySpringRequestListener sentrySpringRequestListener(@NotNull IHub sentryHub, @NotNull SentryRequestResolver requestResolver) {
                return new SentrySpringRequestListener(sentryHub, requestResolver);
            }

            @Bean
            @ConditionalOnMissingBean
            @NotNull
            public SentryExceptionResolver sentryExceptionResolver(@NotNull IHub sentryHub, @NotNull SentryProperties options) {
                return new SentryExceptionResolver(sentryHub, options.getExceptionResolverOrder());
            }

            @Bean
            @Conditional(value={SentryTracingCondition.class})
            @ConditionalOnMissingBean(name={"sentryTracingFilter"})
            public FilterRegistrationBean<SentryTracingFilter> sentryTracingFilter(@NotNull IHub hub) {
                FilterRegistrationBean filter = new FilterRegistrationBean((Filter)new SentryTracingFilter(hub), new ServletRegistrationBean[0]);
                filter.setOrder(Integer.MIN_VALUE);
                return filter;
            }

            @Configuration(proxyBeanMethods=false)
            @ConditionalOnClass(value={SecurityContextHolder.class})
            static class SentrySecurityConfiguration {
                SentrySecurityConfiguration() {
                }

                @Bean
                @Order(value=1)
                @NotNull
                public SpringSecuritySentryUserProvider springSecuritySentryUserProvider(@NotNull SentryOptions sentryOptions) {
                    return new SpringSecuritySentryUserProvider(sentryOptions);
                }
            }
        }
    }
}

