/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.boot;

import io.sentry.IHub;
import io.sentry.spring.boot.SentrySpanClientHttpRequestInterceptor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplateHandler;

class SentrySpanRestTemplateCustomizer
implements RestTemplateCustomizer {
    @NotNull
    private final SentrySpanClientHttpRequestInterceptor interceptor;

    public SentrySpanRestTemplateCustomizer(@NotNull IHub hub) {
        this.interceptor = new SentrySpanClientHttpRequestInterceptor(hub);
    }

    public void customize(@NotNull RestTemplate restTemplate) {
        UriTemplateHandler templateHandler = restTemplate.getUriTemplateHandler();
        templateHandler = this.interceptor.createUriTemplateHandler(templateHandler);
        restTemplate.setUriTemplateHandler(templateHandler);
        List existingInterceptors = restTemplate.getInterceptors();
        if (!existingInterceptors.contains(this.interceptor)) {
            ArrayList<SentrySpanClientHttpRequestInterceptor> interceptors = new ArrayList<SentrySpanClientHttpRequestInterceptor>();
            interceptors.add(this.interceptor);
            interceptors.addAll(existingInterceptors);
            restTemplate.setInterceptors(interceptors);
        }
    }
}

