/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.boot;

import io.sentry.EventProcessor;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.Integration;
import io.sentry.Sentry;
import io.sentry.SentryOptions;
import io.sentry.protocol.SdkVersion;
import io.sentry.spring.SentryExceptionResolver;
import io.sentry.spring.SentryRequestResolver;
import io.sentry.spring.SentryUserProvider;
import io.sentry.spring.SentryUserProviderEventProcessor;
import io.sentry.spring.SentryWebConfiguration;
import io.sentry.spring.boot.InAppIncludesResolver;
import io.sentry.spring.boot.SentryProperties;
import io.sentry.spring.boot.SentrySpanRestTemplateCustomizer;
import io.sentry.spring.tracing.SentrySpan;
import io.sentry.spring.tracing.SentrySpanAdvice;
import io.sentry.spring.tracing.SentryTracingFilter;
import io.sentry.spring.tracing.SentryTransaction;
import io.sentry.spring.tracing.SentryTransactionAdvice;
import io.sentry.transport.ITransport;
import io.sentry.transport.ITransportGate;
import java.util.List;
import javax.servlet.Filter;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.ProceedingJoinPoint;
import org.jetbrains.annotations.NotNull;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.client.RestTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnProperty(name={"sentry.dsn"})
public class SentryAutoConfiguration {

    @Configuration
    @EnableConfigurationProperties(value={SentryProperties.class})
    static class HubConfiguration {
        HubConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"sentryOptionsConfiguration"})
        @Order(value=-2147483648)
        @NotNull
        public Sentry.OptionsConfiguration<SentryOptions> sentryOptionsConfiguration(@NotNull ObjectProvider<SentryOptions.BeforeSendCallback> beforeSendCallback, @NotNull ObjectProvider<SentryOptions.BeforeBreadcrumbCallback> beforeBreadcrumbCallback, @NotNull ObjectProvider<SentryOptions.TracesSamplerCallback> tracesSamplerCallback, @NotNull List<EventProcessor> eventProcessors, @NotNull List<Integration> integrations, @NotNull ObjectProvider<ITransportGate> transportGate, @NotNull List<SentryUserProvider> sentryUserProviders, @NotNull ObjectProvider<ITransport> transport, @NotNull InAppIncludesResolver inAppPackagesResolver) {
            return options -> {
                beforeSendCallback.ifAvailable(arg_0 -> ((SentryOptions)options).setBeforeSend(arg_0));
                beforeBreadcrumbCallback.ifAvailable(arg_0 -> ((SentryOptions)options).setBeforeBreadcrumb(arg_0));
                tracesSamplerCallback.ifAvailable(arg_0 -> ((SentryOptions)options).setTracesSampler(arg_0));
                eventProcessors.forEach(arg_0 -> ((SentryOptions)options).addEventProcessor(arg_0));
                integrations.forEach(arg_0 -> ((SentryOptions)options).addIntegration(arg_0));
                sentryUserProviders.forEach(sentryUserProvider -> options.addEventProcessor((EventProcessor)new SentryUserProviderEventProcessor(sentryUserProvider)));
                transportGate.ifAvailable(arg_0 -> ((SentryOptions)options).setTransportGate(arg_0));
                transport.ifAvailable(arg_0 -> ((SentryOptions)options).setTransport(arg_0));
                inAppPackagesResolver.resolveInAppIncludes().forEach(arg_0 -> ((SentryOptions)options).addInAppInclude(arg_0));
            };
        }

        @Bean
        @NotNull
        public InAppIncludesResolver inAppPackagesResolver() {
            return new InAppIncludesResolver();
        }

        @Bean
        @NotNull
        public IHub sentryHub(@NotNull List<Sentry.OptionsConfiguration<SentryOptions>> optionsConfigurations, @NotNull SentryProperties options, @NotNull ObjectProvider<GitProperties> gitProperties) {
            optionsConfigurations.forEach(optionsConfiguration -> optionsConfiguration.configure((SentryOptions)options));
            gitProperties.ifAvailable(git -> {
                if (options.getRelease() == null && options.isUseGitCommitIdAsRelease()) {
                    options.setRelease(git.getCommitId());
                }
            });
            options.setSentryClientName("sentry.java.spring-boot");
            options.setSdkVersion(HubConfiguration.createSdkVersion(options));
            Sentry.init((SentryOptions)options);
            return HubAdapter.getInstance();
        }

        @NotNull
        private static SdkVersion createSdkVersion(@NotNull SentryOptions sentryOptions) {
            SdkVersion sdkVersion = sentryOptions.getSdkVersion();
            if (sdkVersion == null) {
                sdkVersion = new SdkVersion();
            }
            sdkVersion.setName("sentry.java.spring-boot");
            String version = "4.0.0-alpha.2";
            sdkVersion.setVersion("4.0.0-alpha.2");
            sdkVersion.addPackage("maven:sentry-spring-boot-starter", "4.0.0-alpha.2");
            return sdkVersion;
        }

        @Configuration
        @AutoConfigureBefore(value={RestTemplateAutoConfiguration.class})
        @ConditionalOnClass(value={RestTemplate.class})
        static class SentryPerformanceRestTemplateConfiguration {
            SentryPerformanceRestTemplateConfiguration() {
            }

            @Bean
            public SentrySpanRestTemplateCustomizer sentrySpanRestTemplateCustomizer(IHub hub) {
                return new SentrySpanRestTemplateCustomizer(hub);
            }
        }

        @Configuration
        @ConditionalOnProperty(name={"sentry.enable-tracing"}, havingValue="true")
        @ConditionalOnClass(value={ProceedingJoinPoint.class})
        static class SentryPerformanceAspectsConfiguration {
            SentryPerformanceAspectsConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean(name={"sentryTransactionPointcut"})
            @NotNull
            public Pointcut sentryTransactionPointcut() {
                return new AnnotationMatchingPointcut(null, SentryTransaction.class);
            }

            @Bean
            @NotNull
            public Advice sentryTransactionAdvice(@NotNull IHub hub) {
                return new SentryTransactionAdvice(hub);
            }

            @Bean
            @NotNull
            public Advisor sentryTransactionAdvisor(@NotNull IHub hub, @Qualifier(value="sentryTransactionPointcut") @NotNull Pointcut sentryTransactionPointcut) {
                return new DefaultPointcutAdvisor(sentryTransactionPointcut, this.sentryTransactionAdvice(hub));
            }

            @Bean
            @ConditionalOnMissingBean(name={"sentrySpanPointcut"})
            @NotNull
            public Pointcut sentrySpanPointcut() {
                return new AnnotationMatchingPointcut(null, SentrySpan.class);
            }

            @Bean
            @NotNull
            public Advice sentrySpanAdvice(@NotNull IHub hub) {
                return new SentrySpanAdvice(hub);
            }

            @Bean
            @NotNull
            public Advisor sentrySpanAdvisor(IHub hub, @Qualifier(value="sentrySpanPointcut") @NotNull Pointcut sentrySpanPointcut) {
                return new DefaultPointcutAdvisor(sentrySpanPointcut, this.sentrySpanAdvice(hub));
            }
        }

        @Configuration
        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
        @Import(value={SentryWebConfiguration.class})
        static class SentryWebMvcConfiguration {
            SentryWebMvcConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean
            @NotNull
            public SentryExceptionResolver sentryExceptionResolver(@NotNull IHub sentryHub, @NotNull SentryProperties options) {
                return new SentryExceptionResolver(sentryHub, options.getExceptionResolverOrder());
            }

            @Bean
            @ConditionalOnProperty(name={"sentry.enable-tracing"}, havingValue="true")
            @ConditionalOnMissingBean(name={"sentryTracingFilter"})
            public FilterRegistrationBean<SentryTracingFilter> sentryTracingFilter(@NotNull IHub hub, @NotNull SentryOptions options, @NotNull SentryRequestResolver sentryRequestResolver) {
                FilterRegistrationBean filter = new FilterRegistrationBean((Filter)new SentryTracingFilter(hub, options, sentryRequestResolver), new ServletRegistrationBean[0]);
                filter.setOrder(Integer.MIN_VALUE);
                return filter;
            }
        }
    }
}

