/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.boot;

import io.sentry.EventProcessor;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.Integration;
import io.sentry.Sentry;
import io.sentry.SentryOptions;
import io.sentry.protocol.SdkVersion;
import io.sentry.spring.SentryUserProvider;
import io.sentry.spring.SentryUserProviderEventProcessor;
import io.sentry.spring.SentryWebConfiguration;
import io.sentry.spring.boot.InAppIncludesResolver;
import io.sentry.spring.boot.SentryProperties;
import io.sentry.transport.ITransport;
import io.sentry.transport.ITransportGate;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnProperty(name={"sentry.dsn"})
public class SentryAutoConfiguration {

    @Configuration
    @EnableConfigurationProperties(value={SentryProperties.class})
    static class HubConfiguration {
        HubConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @NotNull
        public Sentry.OptionsConfiguration<SentryOptions> optionsOptionsConfiguration(@NotNull ObjectProvider<SentryOptions.BeforeSendCallback> beforeSendCallback, @NotNull ObjectProvider<SentryOptions.BeforeBreadcrumbCallback> beforeBreadcrumbCallback, @NotNull List<EventProcessor> eventProcessors, @NotNull List<Integration> integrations, @NotNull ObjectProvider<ITransportGate> transportGate, @NotNull List<SentryUserProvider> sentryUserProviders, @NotNull ObjectProvider<ITransport> transport, @NotNull InAppIncludesResolver inAppPackagesResolver) {
            return options -> {
                beforeSendCallback.ifAvailable(arg_0 -> ((SentryOptions)options).setBeforeSend(arg_0));
                beforeBreadcrumbCallback.ifAvailable(arg_0 -> ((SentryOptions)options).setBeforeBreadcrumb(arg_0));
                eventProcessors.forEach(arg_0 -> ((SentryOptions)options).addEventProcessor(arg_0));
                integrations.forEach(arg_0 -> ((SentryOptions)options).addIntegration(arg_0));
                sentryUserProviders.forEach(sentryUserProvider -> options.addEventProcessor((EventProcessor)new SentryUserProviderEventProcessor(sentryUserProvider)));
                transportGate.ifAvailable(arg_0 -> ((SentryOptions)options).setTransportGate(arg_0));
                transport.ifAvailable(arg_0 -> ((SentryOptions)options).setTransport(arg_0));
                inAppPackagesResolver.resolveInAppIncludes().forEach(arg_0 -> ((SentryOptions)options).addInAppInclude(arg_0));
            };
        }

        @Bean
        @NotNull
        public InAppIncludesResolver inAppPackagesResolver() {
            return new InAppIncludesResolver();
        }

        @Bean
        @NotNull
        public IHub sentryHub(@NotNull Sentry.OptionsConfiguration<SentryOptions> optionsConfiguration, @NotNull SentryProperties options, @NotNull ObjectProvider<GitProperties> gitProperties) {
            optionsConfiguration.configure((SentryOptions)options);
            gitProperties.ifAvailable(git -> {
                if (options.getRelease() == null && options.isUseGitCommitIdAsRelease()) {
                    options.setRelease(git.getCommitId());
                }
            });
            options.setSentryClientName("sentry.java.spring-boot");
            options.setSdkVersion(HubConfiguration.createSdkVersion(options));
            Sentry.init((SentryOptions)options);
            return HubAdapter.getInstance();
        }

        @NotNull
        private static SdkVersion createSdkVersion(@NotNull SentryOptions sentryOptions) {
            SdkVersion sdkVersion = sentryOptions.getSdkVersion();
            if (sdkVersion == null) {
                sdkVersion = new SdkVersion();
            }
            sdkVersion.setName("sentry.java.spring-boot");
            String version = "3.1.2";
            sdkVersion.setVersion("3.1.2");
            sdkVersion.addPackage("maven:sentry-spring-boot-starter", "3.1.2");
            return sdkVersion;
        }

        @Configuration
        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
        @Import(value={SentryWebConfiguration.class})
        static class SentryWebMvcConfiguration {
            SentryWebMvcConfiguration() {
            }
        }
    }
}

