/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.boot;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import io.sentry.logback.SentryAppender;
import io.sentry.spring.boot.SentryProperties;
import java.util.Iterator;
import java.util.Optional;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={LoggerContext.class, SentryAppender.class})
@ConditionalOnProperty(name={"sentry.logging.enabled"}, havingValue="true", matchIfMissing=true)
public class SentryLogbackAppenderAutoConfiguration
implements InitializingBean {
    @Autowired
    private SentryProperties sentryProperties;

    public void afterPropertiesSet() {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        if (!this.isSentryAppenderRegistered(rootLogger)) {
            SentryAppender sentryAppender = new SentryAppender();
            sentryAppender.setName("SENTRY_APPENDER");
            sentryAppender.setContext((Context)((LoggerContext)LoggerFactory.getILoggerFactory()));
            Optional.ofNullable(this.sentryProperties.getLogging().getMinimumBreadcrumbLevel()).ifPresent(arg_0 -> ((SentryAppender)sentryAppender).setMinimumBreadcrumbLevel(arg_0));
            Optional.ofNullable(this.sentryProperties.getLogging().getMinimumEventLevel()).ifPresent(arg_0 -> ((SentryAppender)sentryAppender).setMinimumEventLevel(arg_0));
            sentryAppender.start();
            rootLogger.addAppender((Appender)sentryAppender);
        }
    }

    private boolean isSentryAppenderRegistered(Logger logger) {
        Iterator it = logger.iteratorForAppenders();
        while (it.hasNext()) {
            Appender appender = (Appender)it.next();
            if (!appender.getClass().equals(SentryAppender.class)) continue;
            return true;
        }
        return false;
    }
}

