/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import io.sentry.SentryClient;
import io.sentry.SentryClientFactory;
import io.sentry.config.Lookup;
import io.sentry.dsn.Dsn;
import io.sentry.dsn.InvalidDsnException;
import io.sentry.environment.SentryEnvironment;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.MessageInterface;
import io.sentry.event.interfaces.SentryException;
import io.sentry.event.interfaces.SentryInterface;
import io.sentry.event.interfaces.StackTraceInterface;
import io.sentry.util.Util;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SentryAppender
extends AppenderBase<ILoggingEvent> {
    public static final String LOGBACK_MARKER = "logback-Marker";
    public static final String THREAD_NAME = "Sentry-Threadname";
    protected volatile SentryClient sentryClient;
    protected Dsn dsn;
    protected String sentryClientFactory;
    protected String release;
    protected String dist;
    protected String environment;
    protected String serverName;
    protected Level minLevel;
    protected Map<String, String> tags = Collections.emptyMap();
    protected Set<String> extraTags = Collections.emptySet();
    private volatile boolean initialized = false;

    public SentryAppender() {
        this.addFilter(new DropSentryFilter());
    }

    public SentryAppender(SentryClient sentryClient) {
        this();
        this.sentryClient = sentryClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (!this.initialized) {
            SentryAppender sentryAppender = this;
            synchronized (sentryAppender) {
                if (!this.initialized) {
                    try {
                        String extraTags;
                        String tags;
                        String serverName;
                        String environment;
                        String dist;
                        String release;
                        String sentryClientFactory = Lookup.lookup((String)"factory");
                        if (sentryClientFactory != null) {
                            this.setFactory(sentryClientFactory);
                        }
                        if ((release = Lookup.lookup((String)"release")) != null) {
                            this.setRelease(release);
                        }
                        if ((dist = Lookup.lookup((String)"dist")) != null) {
                            this.setDist(dist);
                        }
                        if ((environment = Lookup.lookup((String)"environment")) != null) {
                            this.setEnvironment(environment);
                        }
                        if ((serverName = Lookup.lookup((String)"serverName")) != null) {
                            this.setServerName(serverName);
                        }
                        if ((tags = Lookup.lookup((String)"tags")) != null) {
                            this.setTags(tags);
                        }
                        if ((extraTags = Lookup.lookup((String)"extraTags")) != null) {
                            this.setExtraTags(extraTags);
                        }
                    }
                    finally {
                        this.initialized = true;
                    }
                }
            }
        }
        if (this.sentryClient == null) {
            this.initSentry();
        }
    }

    protected static List<String> formatMessageParameters(Object[] parameters) {
        ArrayList<String> arguments = new ArrayList<String>(parameters.length);
        for (Object argument : parameters) {
            arguments.add(argument != null ? argument.toString() : null);
        }
        return arguments;
    }

    protected static Event.Level formatLevel(Level level) {
        if (level.isGreaterOrEqual(Level.ERROR)) {
            return Event.Level.ERROR;
        }
        if (level.isGreaterOrEqual(Level.WARN)) {
            return Event.Level.WARNING;
        }
        if (level.isGreaterOrEqual(Level.INFO)) {
            return Event.Level.INFO;
        }
        if (level.isGreaterOrEqual(Level.ALL)) {
            return Event.Level.DEBUG;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent iLoggingEvent) {
        if (SentryEnvironment.isManagingThread()) {
            return;
        }
        SentryEnvironment.startManagingThread();
        try {
            if (this.minLevel != null && !iLoggingEvent.getLevel().isGreaterOrEqual(this.minLevel)) {
                return;
            }
            this.lazyInit();
            Event event = this.buildEvent(iLoggingEvent);
            this.sentryClient.sendEvent(event);
        }
        catch (Exception e) {
            this.addError("An exception occurred while creating a new event in Sentry", e);
        }
        finally {
            SentryEnvironment.stopManagingThread();
        }
    }

    protected synchronized void initSentry() {
        try {
            this.sentryClient = SentryClientFactory.sentryClient((Dsn)this.dsn, (String)this.sentryClientFactory);
        }
        catch (InvalidDsnException e) {
            this.addError("An exception occurred during the retrieval of the DSN for Sentry", e);
        }
        catch (Exception e) {
            this.addError("An exception occurred during the creation of a SentryClient instance", e);
        }
    }

    protected Event buildEvent(ILoggingEvent iLoggingEvent) {
        EventBuilder eventBuilder = new EventBuilder().withSdkName("sentry-java:logback").withTimestamp(new Date(iLoggingEvent.getTimeStamp())).withMessage(iLoggingEvent.getFormattedMessage()).withLogger(iLoggingEvent.getLoggerName()).withLevel(SentryAppender.formatLevel(iLoggingEvent.getLevel())).withExtra(THREAD_NAME, (Object)iLoggingEvent.getThreadName());
        if (!Util.isNullOrEmpty((String)this.serverName)) {
            eventBuilder.withServerName(this.serverName.trim());
        }
        if (!Util.isNullOrEmpty((String)this.release)) {
            eventBuilder.withRelease(this.release.trim());
            if (!Util.isNullOrEmpty((String)this.dist)) {
                eventBuilder.withDist(this.dist.trim());
            }
        }
        if (!Util.isNullOrEmpty((String)this.environment)) {
            eventBuilder.withEnvironment(this.environment.trim());
        }
        if (iLoggingEvent.getArgumentArray() != null) {
            eventBuilder.withSentryInterface((SentryInterface)new MessageInterface(iLoggingEvent.getMessage(), SentryAppender.formatMessageParameters(iLoggingEvent.getArgumentArray()), iLoggingEvent.getFormattedMessage()));
        }
        if (iLoggingEvent.getThrowableProxy() != null) {
            eventBuilder.withSentryInterface((SentryInterface)new ExceptionInterface(this.extractExceptionQueue(iLoggingEvent)));
        } else if (iLoggingEvent.getCallerData().length > 0) {
            eventBuilder.withSentryInterface((SentryInterface)new StackTraceInterface(iLoggingEvent.getCallerData()));
        }
        if (iLoggingEvent.getCallerData().length > 0) {
            eventBuilder.withCulprit(iLoggingEvent.getCallerData()[0]);
        } else {
            eventBuilder.withCulprit(iLoggingEvent.getLoggerName());
        }
        for (Map.Entry contextEntry : iLoggingEvent.getLoggerContextVO().getPropertyMap().entrySet()) {
            eventBuilder.withExtra((String)contextEntry.getKey(), contextEntry.getValue());
        }
        Set clientExtraTags = this.sentryClient.getExtraTags();
        for (Map.Entry entry : iLoggingEvent.getMDCPropertyMap().entrySet()) {
            if (this.extraTags.contains(entry.getKey()) || clientExtraTags.contains(entry.getKey())) {
                eventBuilder.withTag((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            eventBuilder.withExtra((String)entry.getKey(), entry.getValue());
        }
        if (iLoggingEvent.getMarker() != null) {
            eventBuilder.withTag(LOGBACK_MARKER, iLoggingEvent.getMarker().getName());
        }
        for (Map.Entry<Object, Object> entry : this.tags.entrySet()) {
            eventBuilder.withTag((String)entry.getKey(), (String)entry.getValue());
        }
        this.sentryClient.runBuilderHelpers(eventBuilder);
        return eventBuilder.build();
    }

    protected Deque<SentryException> extractExceptionQueue(ILoggingEvent iLoggingEvent) {
        ArrayDeque<SentryException> exceptions = new ArrayDeque<SentryException>();
        HashSet<IThrowableProxy> circularityDetector = new HashSet<IThrowableProxy>();
        StackTraceElement[] enclosingStackTrace = new StackTraceElement[]{};
        for (IThrowableProxy throwableProxy = iLoggingEvent.getThrowableProxy(); throwableProxy != null; throwableProxy = throwableProxy.getCause()) {
            if (!circularityDetector.add(throwableProxy)) {
                this.addWarn("Exiting a circular exception!");
                break;
            }
            StackTraceElement[] stackTraceElements = this.toStackTraceElements(throwableProxy);
            StackTraceInterface stackTrace = new StackTraceInterface(stackTraceElements, enclosingStackTrace);
            exceptions.push(this.createSentryExceptionFrom(throwableProxy, stackTrace));
            enclosingStackTrace = stackTraceElements;
        }
        return exceptions;
    }

    protected SentryException createSentryExceptionFrom(IThrowableProxy throwableProxy, StackTraceInterface stackTrace) {
        String exceptionMessage = throwableProxy.getMessage();
        String[] packageNameSimpleName = this.extractPackageSimpleClassName(throwableProxy.getClassName());
        String exceptionPackageName = packageNameSimpleName[0];
        String exceptionClassName = packageNameSimpleName[1];
        return new SentryException(exceptionMessage, exceptionClassName, exceptionPackageName, stackTrace);
    }

    protected String[] extractPackageSimpleClassName(String canonicalClassName) {
        String[] packageNameSimpleName = new String[2];
        try {
            Class<?> exceptionClass = Class.forName(canonicalClassName);
            Package exceptionPackage = exceptionClass.getPackage();
            packageNameSimpleName[0] = exceptionPackage != null ? exceptionPackage.getName() : "(default)";
            packageNameSimpleName[1] = exceptionClass.getSimpleName();
        }
        catch (ClassNotFoundException e) {
            int lastDot = canonicalClassName.lastIndexOf(46);
            if (lastDot != -1) {
                packageNameSimpleName[0] = canonicalClassName.substring(0, lastDot);
                packageNameSimpleName[1] = canonicalClassName.substring(lastDot);
            }
            packageNameSimpleName[0] = "(default)";
            packageNameSimpleName[1] = canonicalClassName;
        }
        return packageNameSimpleName;
    }

    protected StackTraceElement[] toStackTraceElements(IThrowableProxy throwableProxy) {
        StackTraceElementProxy[] stackTraceElementProxies = throwableProxy.getStackTraceElementProxyArray();
        StackTraceElement[] stackTraceElements = new StackTraceElement[stackTraceElementProxies.length];
        int stackTraceElementsLength = stackTraceElementProxies.length;
        for (int i = 0; i < stackTraceElementsLength; ++i) {
            stackTraceElements[i] = stackTraceElementProxies[i].getStackTraceElement();
        }
        return stackTraceElements;
    }

    public void setDsn(String dsn) {
        if (!Util.isNullOrEmpty((String)dsn)) {
            this.dsn = new Dsn(dsn);
        }
    }

    public void setFactory(String factory) {
        this.sentryClientFactory = factory;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public void setDist(String dist) {
        this.dist = dist;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setMinLevel(String minLevel) {
        this.minLevel = minLevel != null ? Level.toLevel((String)minLevel) : null;
    }

    public void setTags(String tags) {
        this.tags = Util.parseTags((String)tags);
    }

    public void setExtraTags(String extraTags) {
        this.extraTags = Util.parseExtraTags((String)extraTags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SentryEnvironment.startManagingThread();
        try {
            if (!this.isStarted()) {
                return;
            }
            super.stop();
            if (this.sentryClient != null) {
                this.sentryClient.closeConnection();
            }
        }
        catch (Exception e) {
            this.addError("An exception occurred while closing the Sentry connection", e);
        }
        finally {
            SentryEnvironment.stopManagingThread();
        }
    }

    private class DropSentryFilter
    extends Filter<ILoggingEvent> {
        private DropSentryFilter() {
        }

        public FilterReply decide(ILoggingEvent event) {
            String loggerName = event.getLoggerName();
            if (loggerName != null && loggerName.startsWith("io.sentry")) {
                return FilterReply.DENY;
            }
            return FilterReply.NEUTRAL;
        }
    }
}

