/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.graphql;

import graphql.GraphQLContext;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryGraphqlExceptionHandler {
    @Nullable
    private final DataFetcherExceptionHandler delegate;
    @NotNull
    private final Object exceptionContextLock = new Object();

    public SentryGraphqlExceptionHandler(@Nullable DataFetcherExceptionHandler delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataFetcherExceptionHandlerResult onException(@NotNull Throwable throwable, @Nullable DataFetchingEnvironment environment, @Nullable DataFetcherExceptionHandlerParameters handlerParameters) {
        GraphQLContext graphQlContext;
        if (environment != null && (graphQlContext = environment.getGraphQlContext()) != null) {
            Object object = this.exceptionContextLock;
            synchronized (object) {
                @NotNull List exceptions = (List)graphQlContext.getOrDefault((Object)"sentry.exceptions", new CopyOnWriteArrayList());
                exceptions.add(throwable);
                graphQlContext.put((Object)"sentry.exceptions", (Object)exceptions);
            }
        }
        if (this.delegate != null) {
            return this.delegate.onException(handlerParameters);
        }
        return null;
    }
}

