/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.Breadcrumb;
import io.sentry.core.CircularFifoQueue;
import io.sentry.core.EventProcessor;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.Session;
import io.sentry.core.SynchronizedQueue;
import io.sentry.core.protocol.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Scope
implements Cloneable {
    @Nullable
    private SentryLevel level;
    @Nullable
    private String transaction;
    @Nullable
    private User user;
    @NotNull
    private List<String> fingerprint = new ArrayList<String>();
    @NotNull
    private Queue<Breadcrumb> breadcrumbs;
    @NotNull
    private Map<String, String> tags = new ConcurrentHashMap<String, String>();
    @NotNull
    private Map<String, Object> extra = new ConcurrentHashMap<String, Object>();
    @NotNull
    private List<EventProcessor> eventProcessors = new CopyOnWriteArrayList<EventProcessor>();
    @NotNull
    private final SentryOptions options;
    @Nullable
    private volatile Session session;
    @NotNull
    private final Object sessionLock = new Object();

    public Scope(@NotNull SentryOptions options) {
        this.options = options;
        this.breadcrumbs = this.createBreadcrumbsList(options.getMaxBreadcrumbs());
    }

    @Nullable
    public SentryLevel getLevel() {
        return this.level;
    }

    public void setLevel(@Nullable SentryLevel level) {
        this.level = level;
    }

    @Nullable
    public String getTransaction() {
        return this.transaction;
    }

    public void setTransaction(@Nullable String transaction) {
        this.transaction = transaction;
    }

    @Nullable
    public User getUser() {
        return this.user;
    }

    public void setUser(@Nullable User user) {
        this.user = user;
    }

    @NotNull
    List<String> getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(@NotNull List<String> fingerprint) {
        this.fingerprint = fingerprint;
    }

    @NotNull
    Queue<Breadcrumb> getBreadcrumbs() {
        return this.breadcrumbs;
    }

    @Nullable
    private Breadcrumb executeBeforeBreadcrumb(@NotNull SentryOptions.BeforeBreadcrumbCallback callback, @NotNull Breadcrumb breadcrumb, @Nullable Object hint) {
        try {
            breadcrumb = callback.execute(breadcrumb, hint);
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "The BeforeBreadcrumbCallback callback threw an exception. It will be added as breadcrumb and continue.", e);
            breadcrumb.setData("sentry:message", e.getMessage());
        }
        return breadcrumb;
    }

    public void addBreadcrumb(@NotNull Breadcrumb breadcrumb, @Nullable Object hint) {
        if (breadcrumb == null) {
            return;
        }
        SentryOptions.BeforeBreadcrumbCallback callback = this.options.getBeforeBreadcrumb();
        if (callback != null) {
            breadcrumb = this.executeBeforeBreadcrumb(callback, breadcrumb, hint);
        }
        if (breadcrumb != null) {
            this.breadcrumbs.add(breadcrumb);
        } else {
            this.options.getLogger().log(SentryLevel.INFO, "Breadcrumb was dropped by beforeBreadcrumb", new Object[0]);
        }
    }

    public void addBreadcrumb(@NotNull Breadcrumb breadcrumb) {
        this.addBreadcrumb(breadcrumb, null);
    }

    public void clearBreadcrumbs() {
        this.breadcrumbs.clear();
    }

    public void clear() {
        this.level = null;
        this.transaction = null;
        this.user = null;
        this.fingerprint.clear();
        this.breadcrumbs.clear();
        this.tags.clear();
        this.extra.clear();
        this.eventProcessors.clear();
    }

    @NotNull
    Map<String, String> getTags() {
        return this.tags;
    }

    public void setTag(@NotNull String key, @NotNull String value) {
        this.tags.put(key, value);
    }

    public void removeTag(@NotNull String key) {
        this.tags.remove(key);
    }

    @NotNull
    Map<String, Object> getExtras() {
        return this.extra;
    }

    public void setExtra(@NotNull String key, @NotNull String value) {
        this.extra.put(key, value);
    }

    public void removeExtra(@NotNull String key) {
        this.extra.remove(key);
    }

    @NotNull
    private Queue<Breadcrumb> createBreadcrumbsList(int maxBreadcrumb) {
        return SynchronizedQueue.synchronizedQueue(new CircularFifoQueue(maxBreadcrumb));
    }

    @NotNull
    public Scope clone() throws CloneNotSupportedException {
        Scope clone = (Scope)super.clone();
        SentryLevel levelRef = this.level;
        clone.level = levelRef != null ? SentryLevel.valueOf(levelRef.name().toUpperCase(Locale.ROOT)) : null;
        User userRef = this.user;
        clone.user = userRef != null ? userRef.clone() : null;
        clone.fingerprint = new ArrayList<String>(this.fingerprint);
        clone.eventProcessors = new CopyOnWriteArrayList<EventProcessor>(this.eventProcessors);
        Queue<Breadcrumb> breadcrumbsRef = this.breadcrumbs;
        Queue<Breadcrumb> breadcrumbsClone = this.createBreadcrumbsList(this.options.getMaxBreadcrumbs());
        for (Breadcrumb item : breadcrumbsRef) {
            Breadcrumb breadcrumbClone = item.clone();
            breadcrumbsClone.add(breadcrumbClone);
        }
        clone.breadcrumbs = breadcrumbsClone;
        Map<String, String> tagsRef = this.tags;
        ConcurrentHashMap<String, String> tagsClone = new ConcurrentHashMap<String, String>();
        for (Map.Entry entry : tagsRef.entrySet()) {
            if (entry == null) continue;
            tagsClone.put((String)entry.getKey(), (String)entry.getValue());
        }
        clone.tags = tagsClone;
        Map<String, Object> extraRef = this.extra;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> item : extraRef.entrySet()) {
            if (item == null) continue;
            hashMap.put(item.getKey(), item.getValue());
        }
        clone.extra = hashMap;
        return clone;
    }

    @NotNull
    List<EventProcessor> getEventProcessors() {
        return this.eventProcessors;
    }

    public void addEventProcessor(@NotNull EventProcessor eventProcessor) {
        this.eventProcessors.add(eventProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void withSession(@NotNull IWithSession sessionCallback) {
        Object object = this.sessionLock;
        synchronized (object) {
            sessionCallback.accept(this.session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    SessionPair startSession() {
        SessionPair pair;
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.session != null) {
                this.session.end();
            }
            Session previousSession = this.session;
            this.session = new Session(this.options.getDistinctId(), this.user, this.options.getEnvironment(), this.options.getRelease());
            Session previousClone = previousSession != null ? previousSession.clone() : null;
            pair = new SessionPair(this.session.clone(), previousClone);
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Session endSession() {
        Session previousSession = null;
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.session != null) {
                this.session.end();
                previousSession = this.session.clone();
                this.session = null;
            }
        }
        return previousSession;
    }

    static final class SessionPair {
        @Nullable
        private final Session previous;
        @NotNull
        private final Session current;

        public SessionPair(@NotNull Session current, @Nullable Session previous) {
            this.current = current;
            this.previous = previous;
        }

        @Nullable
        public Session getPrevious() {
            return this.previous;
        }

        @NotNull
        public Session getCurrent() {
            return this.current;
        }
    }

    static interface IWithSession {
        public void accept(@Nullable Session var1);
    }
}

