/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.DateUtils;
import io.sentry.core.IUnknownPropertiesConsumer;
import io.sentry.core.SentryLevel;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Breadcrumb
implements Cloneable,
IUnknownPropertiesConsumer {
    @NotNull
    private final Date timestamp;
    @Nullable
    private String message;
    @Nullable
    private String type;
    @NotNull
    private Map<String, Object> data = new ConcurrentHashMap<String, Object>();
    @Nullable
    private String category;
    @Nullable
    private SentryLevel level;
    @Nullable
    private Map<String, Object> unknown;

    Breadcrumb(@NotNull Date timestamp) {
        this.timestamp = timestamp;
    }

    public Breadcrumb() {
        this(DateUtils.getCurrentDateTime());
    }

    public Breadcrumb(@Nullable String message) {
        this();
        this.message = message;
    }

    @NotNull
    public Date getTimestamp() {
        return (Date)this.timestamp.clone();
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable String message) {
        this.message = message;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(@Nullable String type) {
        this.type = type;
    }

    @NotNull
    Map<String, Object> getData() {
        return this.data;
    }

    @Nullable
    public Object getData(@NotNull String key) {
        return this.data.get(key);
    }

    public void setData(@NotNull String key, @NotNull Object value) {
        this.data.put(key, value);
    }

    public void removeData(@NotNull String key) {
        this.data.remove(key);
    }

    @Nullable
    public String getCategory() {
        return this.category;
    }

    public void setCategory(@Nullable String category) {
        this.category = category;
    }

    @Nullable
    public SentryLevel getLevel() {
        return this.level;
    }

    public void setLevel(@Nullable SentryLevel level) {
        this.level = level;
    }

    @Override
    @ApiStatus.Internal
    public void acceptUnknownProperties(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Nullable
    Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @NotNull
    public Breadcrumb clone() throws CloneNotSupportedException {
        Breadcrumb clone = (Breadcrumb)super.clone();
        Map<String, Object> dataRef = this.data;
        if (dataRef != null) {
            ConcurrentHashMap<String, Object> dataClone = new ConcurrentHashMap<String, Object>();
            for (Map.Entry<String, Object> item : dataRef.entrySet()) {
                if (item == null) continue;
                dataClone.put(item.getKey(), item.getValue());
            }
            clone.data = dataClone;
        } else {
            clone.data = null;
        }
        Map<String, Object> unknownRef = this.unknown;
        if (unknownRef != null) {
            HashMap<String, Object> unknownClone = new HashMap<String, Object>();
            for (Map.Entry<String, Object> item : unknownRef.entrySet()) {
                if (item == null) continue;
                unknownClone.put(item.getKey(), item.getValue());
            }
            clone.unknown = unknownClone;
        } else {
            clone.unknown = null;
        }
        SentryLevel levelRef = this.level;
        clone.level = levelRef != null ? SentryLevel.valueOf(levelRef.name().toUpperCase(Locale.ROOT)) : null;
        return clone;
    }
}

