/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.CredentialsSettingConfigurator;
import io.sentry.core.Dsn;
import io.sentry.core.SentryOptions;
import io.sentry.core.transport.HttpTransport;
import io.sentry.core.transport.ITransport;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

final class HttpTransportFactory {
    private HttpTransportFactory() {
    }

    static ITransport create(@NotNull SentryOptions options) {
        URL sentryUrl;
        Dsn parsedDsn = new Dsn(options.getDsn());
        CredentialsSettingConfigurator credentials = new CredentialsSettingConfigurator(parsedDsn, options.getSentryClientName());
        try {
            sentryUrl = parsedDsn.getSentryUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to compose the Sentry's server URL.", e);
        }
        return new HttpTransport(options, credentials, 5000, 5000, false, sentryUrl);
    }
}

