/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.sentry.core.DateUtils;
import io.sentry.core.Session;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class SessionAdapter
extends TypeAdapter<Session> {
    public void write(JsonWriter writer, Session value) throws IOException {
        int errorCount;
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        if (value.getSessionId() != null) {
            writer.name("sid").value(value.getSessionId().toString());
        }
        if (value.getDistinctId() != null) {
            writer.name("did").value(value.getDistinctId());
        }
        if (value.getInit() != null) {
            writer.name("init").value(value.getInit());
        }
        if (value.getStarted() != null) {
            writer.name("started").value(DateUtils.getTimestamp(value.getStarted()));
        }
        if (value.getStatus() != null) {
            writer.name("status").value(value.getStatus().name().toLowerCase(Locale.ROOT));
        }
        if (value.getSequence() != null) {
            writer.name("seq").value((Number)value.getSequence());
        }
        if ((errorCount = value.errorCount()) > 0) {
            writer.name("errors").value((long)errorCount);
        }
        if (value.getDuration() != null) {
            writer.name("duration").value((Number)value.getDuration());
        }
        if (value.getTimestamp() != null) {
            writer.name("timestamp").value(DateUtils.getTimestamp(value.getTimestamp()));
        }
        boolean hasInitAttrs = false;
        if (value.getRelease() != null) {
            hasInitAttrs = this.initAttrs(writer, hasInitAttrs);
            writer.name("release").value(value.getRelease());
        }
        if (value.getEnvironment() != null) {
            hasInitAttrs = this.initAttrs(writer, hasInitAttrs);
            writer.name("environment").value(value.getEnvironment());
        }
        if (value.getIpAddress() != null) {
            hasInitAttrs = this.initAttrs(writer, hasInitAttrs);
            writer.name("ip_address").value(value.getIpAddress());
        }
        if (value.getUserAgent() != null) {
            hasInitAttrs = this.initAttrs(writer, hasInitAttrs);
            writer.name("user_agent").value(value.getUserAgent());
        }
        if (hasInitAttrs) {
            writer.endObject();
        }
        writer.endObject();
    }

    private boolean initAttrs(JsonWriter writer, boolean hasInitAtts) throws IOException {
        if (!hasInitAtts) {
            writer.name("attrs").beginObject();
        }
        return true;
    }

    public Session read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        UUID sid = null;
        String did = null;
        Boolean init = null;
        Date started = null;
        Session.State status = null;
        int errors = 0;
        Long seq = null;
        Double duration = null;
        Date timestamp = null;
        String release = null;
        String environment = null;
        String ipAddress = null;
        String userAgent = null;
        reader.beginObject();
        block36: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "sid": {
                    sid = UUID.fromString(reader.nextString());
                    continue block36;
                }
                case "did": {
                    did = reader.nextString();
                    continue block36;
                }
                case "init": {
                    init = reader.nextBoolean();
                    continue block36;
                }
                case "started": {
                    started = DateUtils.getDateTime(reader.nextString());
                    continue block36;
                }
                case "status": {
                    status = Session.State.valueOf(this.capitalize(reader.nextString()));
                    continue block36;
                }
                case "errors": {
                    errors = reader.nextInt();
                    continue block36;
                }
                case "seq": {
                    seq = reader.nextLong();
                    continue block36;
                }
                case "duration": {
                    duration = reader.nextDouble();
                    continue block36;
                }
                case "timestamp": {
                    timestamp = DateUtils.getDateTime(reader.nextString());
                    continue block36;
                }
                case "attrs": {
                    reader.beginObject();
                    block37: while (reader.hasNext()) {
                        switch (reader.nextName()) {
                            case "release": {
                                release = reader.nextString();
                                continue block37;
                            }
                            case "environment": {
                                environment = reader.nextString();
                                continue block37;
                            }
                            case "ip_address": {
                                ipAddress = reader.nextString();
                                continue block37;
                            }
                            case "user_agent": {
                                userAgent = reader.nextString();
                                continue block37;
                            }
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue block36;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return new Session(status, started, timestamp, errors, did, sid, init, seq, duration, ipAddress, userAgent, environment, release);
    }

    String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase(Locale.ROOT) + str.substring(1);
    }
}

