/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.AsyncConnectionFactory;
import io.sentry.core.Breadcrumb;
import io.sentry.core.EventProcessor;
import io.sentry.core.HttpTransportFactory;
import io.sentry.core.ISentryClient;
import io.sentry.core.Scope;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.cache.DiskCache;
import io.sentry.core.hints.Cached;
import io.sentry.core.protocol.SentryId;
import io.sentry.core.transport.Connection;
import io.sentry.core.transport.ITransport;
import io.sentry.core.transport.ITransportGate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.Nullable;

public final class SentryClient
implements ISentryClient {
    static final String SENTRY_PROTOCOL_VERSION = "7";
    private boolean enabled;
    private final SentryOptions options;
    private final Connection connection;
    private final Random random;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    SentryClient(SentryOptions options) {
        this(options, null);
    }

    public SentryClient(SentryOptions options, @Nullable Connection connection) {
        ITransportGate transportGate;
        this.options = options;
        this.enabled = true;
        ITransport transport = options.getTransport();
        if (transport == null) {
            transport = HttpTransportFactory.create(options);
            options.setTransport(transport);
        }
        if ((transportGate = options.getTransportGate()) == null) {
            transportGate = () -> true;
            options.setTransportGate(transportGate);
        }
        if (connection == null) {
            DiskCache cache = new DiskCache(options);
            connection = AsyncConnectionFactory.create(options, cache);
        }
        this.connection = connection;
        this.random = options.getSampleRate() == null ? null : new Random();
    }

    @Override
    public SentryId captureEvent(SentryEvent event, @Nullable Scope scope, @Nullable Object hint) {
        if (!this.sample()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event %s was dropped due to sampling decision.", event.getEventId());
            return SentryId.EMPTY_ID;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Capturing event: %s", event.getEventId());
        if (!(hint instanceof Cached)) {
            if ((event = this.applyScope(event, scope, hint)) == null) {
                return SentryId.EMPTY_ID;
            }
        } else {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying scope: %s", event.getEventId());
        }
        for (EventProcessor processor : this.options.getEventProcessors()) {
            event = processor.process(event, hint);
            if (event != null) continue;
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by processor: %s", processor.getClass().getName());
            break;
        }
        if (event == null) {
            return SentryId.EMPTY_ID;
        }
        if ((event = this.executeBeforeSend(event, hint)) == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by beforeSend", new Object[0]);
            return SentryId.EMPTY_ID;
        }
        try {
            this.connection.send(event, hint);
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.WARNING, "Capturing event " + event.getEventId() + " failed.", e);
        }
        return event.getEventId();
    }

    private SentryEvent applyScope(SentryEvent event, @Nullable Scope scope, @Nullable Object hint) {
        if (scope != null) {
            if (event.getTransaction() == null) {
                event.setTransaction(scope.getTransaction());
            }
            if (event.getUser() == null) {
                event.setUser(scope.getUser());
            }
            if (event.getFingerprints() == null) {
                event.setFingerprints(scope.getFingerprint());
            }
            if (event.getBreadcrumbs() == null) {
                event.setBreadcrumbs(new ArrayList<Breadcrumb>(scope.getBreadcrumbs()));
            } else {
                event.getBreadcrumbs().addAll(scope.getBreadcrumbs());
            }
            if (event.getTags() == null) {
                event.setTags(new HashMap<String, String>(scope.getTags()));
            } else {
                for (Map.Entry<String, String> entry : scope.getTags().entrySet()) {
                    if (event.getTags().containsKey(entry.getKey())) continue;
                    event.getTags().put(entry.getKey(), entry.getValue());
                }
            }
            if (event.getExtras() == null) {
                event.setExtras(new HashMap<String, Object>(scope.getExtras()));
            } else {
                for (Map.Entry<String, Object> entry : scope.getExtras().entrySet()) {
                    if (event.getExtras().containsKey(entry.getKey())) continue;
                    event.getExtras().put(entry.getKey(), entry.getValue());
                }
            }
            if (scope.getLevel() != null) {
                event.setLevel(scope.getLevel());
            }
            for (EventProcessor eventProcessor : scope.getEventProcessors()) {
                event = eventProcessor.process(event, hint);
                if (event != null) continue;
                this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by scope processor: %s", eventProcessor.getClass().getName());
                break;
            }
        }
        return event;
    }

    private SentryEvent executeBeforeSend(SentryEvent event, @Nullable Object hint) {
        SentryOptions.BeforeSendCallback beforeSend = this.options.getBeforeSend();
        if (beforeSend != null) {
            try {
                event = beforeSend.execute(event, hint);
            }
            catch (Exception e) {
                this.options.getLogger().log(SentryLevel.ERROR, "The BeforeSend callback threw an exception. It will be added as breadcrumb and continue.", e);
                Breadcrumb breadcrumb = new Breadcrumb();
                breadcrumb.setMessage("BeforeSend callback failed.");
                breadcrumb.setCategory("SentryClient");
                breadcrumb.setLevel(SentryLevel.ERROR);
                breadcrumb.setData("sentry:message", e.getMessage());
                event.addBreadcrumb(breadcrumb);
            }
        }
        return event;
    }

    @Override
    public void close() {
        this.options.getLogger().log(SentryLevel.INFO, "Closing SentryClient.", new Object[0]);
        try {
            this.flush(this.options.getShutdownTimeout());
            this.connection.close();
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.WARNING, "Failed to close the connection to the Sentry Server.", e);
        }
        this.enabled = false;
    }

    @Override
    public void flush(long timeoutMills) {
    }

    private boolean sample() {
        if (this.options.getSampleRate() != null && this.random != null) {
            double sampling = this.options.getSampleRate();
            return !(sampling < this.random.nextDouble());
        }
        return true;
    }
}

