/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.compose.gestures;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.ModifierInfo;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.Owner;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsModifier;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import io.sentry.ILogger;
import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.compose.SentryComposeHelper;
import io.sentry.compose.SentryComposeHelperKt;
import io.sentry.internal.gestures.GestureTargetLocator;
import io.sentry.internal.gestures.UiElement;
import io.sentry.util.AutoClosableReentrantLock;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J,\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/sentry/compose/gestures/ComposeGestureTargetLocator;", "Lio/sentry/internal/gestures/GestureTargetLocator;", "logger", "Lio/sentry/ILogger;", "(Lio/sentry/ILogger;)V", "composeHelper", "Lio/sentry/compose/SentryComposeHelper;", "lock", "Lio/sentry/util/AutoClosableReentrantLock;", "layoutNodeBoundsContain", "", "root", "Landroidx/compose/ui/node/LayoutNode;", "node", "x", "", "y", "locate", "Lio/sentry/internal/gestures/UiElement;", "", "targetType", "Lio/sentry/internal/gestures/UiElement$Type;", "Companion", "sentry-compose_release"})
@StabilityInferred(parameters=0)
public final class ComposeGestureTargetLocator
implements GestureTargetLocator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ILogger logger;
    @Nullable
    private volatile SentryComposeHelper composeHelper;
    @NotNull
    private final AutoClosableReentrantLock lock;
    public static final int $stable = 8;
    @NotNull
    private static final String ORIGIN = "jetpack_compose";

    public ComposeGestureTargetLocator(@NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.lock = new AutoClosableReentrantLock();
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-compose", "8.27.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public UiElement locate(@Nullable Object root, float x, float y, @NotNull UiElement.Type targetType) {
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        if (!(root instanceof Owner)) {
            return null;
        }
        if (this.composeHelper == null) {
            AutoCloseable autoCloseable = (AutoCloseable)this.lock.acquire();
            Throwable throwable = null;
            try {
                ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
                boolean bl = false;
                if (this.composeHelper == null) {
                    this.composeHelper = new SentryComposeHelper(this.logger);
                }
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        LayoutNode rootLayoutNode = ((Owner)root).getRoot();
        Queue queue = new LinkedList();
        queue.add(rootLayoutNode);
        String targetTag = null;
        String lastKnownTag = null;
        while (!queue.isEmpty()) {
            LayoutNode node;
            if ((LayoutNode)queue.poll() == null) continue;
            if (node.isPlaced() && this.layoutNodeBoundsContain(rootLayoutNode, node, x, y)) {
                boolean isClickable = false;
                boolean isScrollable = false;
                List modifiers = node.getModifierInfo();
                int n = ((Collection)modifiers).size();
                for (int index = 0; index < n; ++index) {
                    ModifierInfo modifierInfo = (ModifierInfo)modifiers.get(index);
                    SentryComposeHelper sentryComposeHelper = this.composeHelper;
                    Intrinsics.checkNotNull((Object)sentryComposeHelper);
                    String tag = sentryComposeHelper.extractTag(modifierInfo.getModifier());
                    if (tag != null) {
                        lastKnownTag = tag;
                    }
                    if (modifierInfo.getModifier() instanceof SemanticsModifier) {
                        Modifier modifier = modifierInfo.getModifier();
                        Intrinsics.checkNotNull((Object)modifier, (String)"null cannot be cast to non-null type androidx.compose.ui.semantics.SemanticsModifier");
                        SemanticsModifier semanticsModifierCore = (SemanticsModifier)modifier;
                        SemanticsConfiguration semanticsConfiguration = semanticsModifierCore.getSemanticsConfiguration();
                        for (Map.Entry item : semanticsConfiguration) {
                            String key = ((SemanticsPropertyKey)item.getKey()).getName();
                            if (Intrinsics.areEqual((Object)"ScrollBy", (Object)key)) {
                                isScrollable = true;
                                continue;
                            }
                            if (!Intrinsics.areEqual((Object)"OnClick", (Object)key)) continue;
                            isClickable = true;
                        }
                        continue;
                    }
                    Modifier modifier = modifierInfo.getModifier();
                    String type = modifier.getClass().getName();
                    if (Intrinsics.areEqual((Object)"androidx.compose.foundation.ClickableElement", (Object)type) || Intrinsics.areEqual((Object)"androidx.compose.foundation.CombinedClickableElement", (Object)type)) {
                        isClickable = true;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)"androidx.compose.foundation.ScrollingLayoutElement", (Object)type)) continue;
                    isScrollable = true;
                }
                if (isClickable && targetType == UiElement.Type.CLICKABLE) {
                    targetTag = lastKnownTag;
                }
                if (isScrollable && targetType == UiElement.Type.SCROLLABLE) {
                    targetTag = lastKnownTag;
                    break;
                }
            }
            queue.addAll(node.getZSortedChildren().asMutableList());
        }
        return targetTag == null ? null : new UiElement(null, null, null, targetTag, ORIGIN);
    }

    private final boolean layoutNodeBoundsContain(LayoutNode root, LayoutNode node, float x, float y) {
        Rect bounds = SentryComposeHelperKt.boundsInWindow(node.getCoordinates(), root.getCoordinates());
        return bounds.contains-k-4lQ0M(OffsetKt.Offset((float)x, (float)y));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/sentry/compose/gestures/ComposeGestureTargetLocator$Companion;", "", "()V", "ORIGIN", "", "sentry-compose_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

