/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.compose;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.LayoutNodeLayoutDelegate;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryComposeHelper {
    @NotNull
    private final ILogger logger;
    private Field layoutDelegateField = null;

    public SentryComposeHelper(@NotNull ILogger logger) {
        this.logger = logger;
        try {
            Class<?> clazz = Class.forName("androidx.compose.ui.node.LayoutNode");
            this.layoutDelegateField = clazz.getDeclaredField("layoutDelegate");
            this.layoutDelegateField.setAccessible(true);
        }
        catch (Exception e) {
            logger.log(SentryLevel.WARNING, "Could not find LayoutNode.layoutDelegate field", new Object[0]);
        }
    }

    @Nullable
    public Rect getLayoutNodeBoundsInWindow(@NotNull LayoutNode node) {
        if (this.layoutDelegateField != null) {
            try {
                LayoutNodeLayoutDelegate delegate = (LayoutNodeLayoutDelegate)this.layoutDelegateField.get(node);
                return LayoutCoordinatesKt.boundsInWindow((LayoutCoordinates)delegate.getOuterCoordinator().getCoordinates());
            }
            catch (Exception e) {
                this.logger.log(SentryLevel.WARNING, "Could not fetch position for LayoutNode", (Throwable)e);
            }
        }
        return null;
    }
}

