/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.compose.gestures;

import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.layout.ModifierInfo;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.Owner;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsModifier;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.internal.gestures.GestureTargetLocator;
import io.sentry.internal.gestures.UiElement;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposeGestureTargetLocator
implements GestureTargetLocator {
    public ComposeGestureTargetLocator() {
        SentryIntegrationPackageStorage.getInstance().addIntegration("ComposeUserInteraction");
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-compose", "6.17.0");
    }

    @Nullable
    public UiElement locate(@NotNull Object root, float x, float y, UiElement.Type targetType) {
        String targetTag = null;
        if (!(root instanceof Owner)) {
            return null;
        }
        LinkedList<LayoutNode> queue = new LinkedList<LayoutNode>();
        queue.add(((Owner)root).getRoot());
        while (!queue.isEmpty()) {
            LayoutNode node = (LayoutNode)queue.poll();
            if (node == null) continue;
            if (node.isPlaced() && ComposeGestureTargetLocator.layoutNodeBoundsContain(node, x, y)) {
                boolean isClickable = false;
                boolean isScrollable = false;
                String testTag = null;
                List modifiers = node.getModifierInfo();
                for (ModifierInfo modifierInfo : modifiers) {
                    if (!(modifierInfo.getModifier() instanceof SemanticsModifier)) continue;
                    SemanticsModifier semanticsModifierCore = (SemanticsModifier)modifierInfo.getModifier();
                    SemanticsConfiguration semanticsConfiguration = semanticsModifierCore.getSemanticsConfiguration();
                    for (Map.Entry entry : semanticsConfiguration) {
                        String key = ((SemanticsPropertyKey)entry.getKey()).getName();
                        if ("ScrollBy".equals(key)) {
                            isScrollable = true;
                            continue;
                        }
                        if ("OnClick".equals(key)) {
                            isClickable = true;
                            continue;
                        }
                        if (!"TestTag".equals(key) || !(entry.getValue() instanceof String)) continue;
                        testTag = (String)entry.getValue();
                    }
                }
                if (isClickable && targetType == UiElement.Type.CLICKABLE) {
                    targetTag = testTag;
                }
                if (isScrollable && targetType == UiElement.Type.SCROLLABLE) {
                    targetTag = testTag;
                    break;
                }
            }
            queue.addAll(node.getZSortedChildren().asMutableList());
        }
        if (targetTag == null) {
            return null;
        }
        return new UiElement(null, null, null, targetTag);
    }

    private static boolean layoutNodeBoundsContain(@NotNull LayoutNode node, float x, float y) {
        int nodeHeight = node.getHeight();
        int nodeWidth = node.getWidth();
        long nodePosition = LayoutCoordinatesKt.positionInWindow((LayoutCoordinates)node.getCoordinates());
        int nodeX = (int)Float.intBitsToFloat((int)(nodePosition >> 32));
        int nodeY = (int)Float.intBitsToFloat((int)nodePosition);
        return x >= (float)nodeX && x <= (float)(nodeX + nodeWidth) && y >= (float)nodeY && y <= (float)(nodeY + nodeHeight);
    }
}

