/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import io.sentry.DefaultSentryClientFactory;
import io.sentry.Sentry;
import io.sentry.SentryClient;
import io.sentry.android.ANRWatchDog;
import io.sentry.android.ApplicationNotResponding;
import io.sentry.android.event.helper.AndroidEventBuilderHelper;
import io.sentry.buffer.Buffer;
import io.sentry.buffer.DiskBuffer;
import io.sentry.config.Lookup;
import io.sentry.context.ContextManager;
import io.sentry.context.SingletonContextManager;
import io.sentry.dsn.Dsn;
import io.sentry.event.EventBuilder;
import io.sentry.event.helper.EventBuilderHelper;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.ExceptionMechanism;
import io.sentry.event.interfaces.ExceptionMechanismThrowable;
import io.sentry.event.interfaces.SentryInterface;
import io.sentry.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class AndroidSentryClientFactory
extends DefaultSentryClientFactory {
    public static final String TAG = AndroidSentryClientFactory.class.getName();
    private static final String DEFAULT_BUFFER_DIR = "sentry-buffered-events";
    private static volatile ANRWatchDog anrWatchDog;
    private Context ctx;

    public AndroidSentryClientFactory(Application app) {
        this(app, Lookup.getDefault());
    }

    public AndroidSentryClientFactory(Application app, Lookup lookup) {
        super(lookup);
        Log.d((String)TAG, (String)"Construction of Android Sentry from Android Application.");
        this.ctx = app.getApplicationContext();
    }

    public AndroidSentryClientFactory(Context ctx) {
        this(ctx, Lookup.getDefault());
    }

    public AndroidSentryClientFactory(Context ctx, Lookup lookup) {
        super(lookup);
        Log.d((String)TAG, (String)"Construction of Android Sentry from Android Context.");
        this.ctx = ctx.getApplicationContext();
        if (this.ctx == null) {
            this.ctx = ctx;
        }
    }

    public SentryClient createSentryClient(Dsn dsn) {
        if (!this.checkPermission("android.permission.INTERNET")) {
            Log.e((String)TAG, (String)"android.permission.INTERNET is required to connect to the Sentry server, please add it to your AndroidManifest.xml");
        }
        Log.d((String)TAG, (String)("Sentry init with ctx='" + this.ctx.toString() + "'"));
        String protocol = dsn.getProtocol();
        if (protocol.equalsIgnoreCase("noop")) {
            Log.w((String)TAG, (String)"*** Couldn't find a suitable DSN, Sentry operations will do nothing! See documentation: https://docs.sentry.io/clients/java/modules/android/ ***");
        } else if (!protocol.equalsIgnoreCase("http") && !protocol.equalsIgnoreCase("https")) {
            String async = this.lookup.get("async", dsn);
            if (async != null && async.equalsIgnoreCase("false")) {
                throw new IllegalArgumentException("Sentry Android cannot use synchronous connections, remove 'async=false' from your options.");
            }
            throw new IllegalArgumentException("Only 'http' or 'https' connections are supported in Sentry Android, but received: " + protocol);
        }
        SentryClient sentryClient = super.createSentryClient(dsn);
        sentryClient.addBuilderHelper((EventBuilderHelper)new AndroidEventBuilderHelper(this.ctx));
        boolean enableAnrTracking = "true".equalsIgnoreCase(this.lookup.get("anr.enable", dsn));
        Log.d((String)TAG, (String)("ANR is='" + String.valueOf(enableAnrTracking) + "'"));
        if (enableAnrTracking && anrWatchDog == null) {
            String timeIntervalMsConfig = this.lookup.get("anr.timeoutIntervalMs", dsn);
            int timeoutIntervalMs = timeIntervalMsConfig != null ? Integer.parseInt(timeIntervalMsConfig) : 5000;
            Log.d((String)TAG, (String)("ANR timeoutIntervalMs is='" + String.valueOf(timeoutIntervalMs) + "'"));
            anrWatchDog = new ANRWatchDog(timeoutIntervalMs, new ANRWatchDog.ANRListener(){

                @Override
                public void onAppNotResponding(ApplicationNotResponding error) {
                    Log.d((String)TAG, (String)("ANR triggered='" + error.getMessage() + "'"));
                    EventBuilder builder = new EventBuilder();
                    builder.withTag("thread_state", error.getState().toString());
                    ExceptionMechanism mechanism = new ExceptionMechanism("anr", false);
                    ExceptionMechanismThrowable throwable = new ExceptionMechanismThrowable(mechanism, (Throwable)error);
                    builder.withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)throwable));
                    Sentry.capture((EventBuilder)builder);
                }
            });
            anrWatchDog.start();
        }
        return sentryClient;
    }

    protected Collection<String> getInAppFrames(Dsn dsn) {
        Collection inAppFrames = super.getInAppFrames(dsn);
        if (inAppFrames.isEmpty()) {
            PackageInfo info = null;
            try {
                info = this.ctx.getPackageManager().getPackageInfo(this.ctx.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)TAG, (String)"Error getting package information.", (Throwable)e);
            }
            if (info != null && !Util.isNullOrEmpty((String)info.packageName)) {
                ArrayList<String> newPackages = new ArrayList<String>(1);
                newPackages.add(info.packageName);
                return newPackages;
            }
        }
        return inAppFrames;
    }

    protected Buffer getBuffer(Dsn dsn) {
        String bufferDirOpt = this.lookup.get("buffer.dir", dsn);
        File bufferDir = bufferDirOpt != null ? new File(bufferDirOpt) : new File(this.ctx.getCacheDir().getAbsolutePath(), DEFAULT_BUFFER_DIR);
        Log.d((String)TAG, (String)("Using buffer dir: " + bufferDir.getAbsolutePath()));
        return new DiskBuffer(bufferDir, this.getBufferSize(dsn));
    }

    protected ContextManager getContextManager(Dsn dsn) {
        return new SingletonContextManager();
    }

    private boolean checkPermission(String permission) {
        int res = this.ctx.checkCallingOrSelfPermission(permission);
        return res == 0;
    }
}

