/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android;

import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import io.sentry.android.ApplicationNotResponding;

class ANRWatchDog
extends Thread {
    private static final String TAG = ANRWatchDog.class.getName();
    private ANRListener _anrListener = null;
    private final Handler _uiHandler = new Handler(Looper.getMainLooper());
    private final int _timeoutInterval;
    private volatile long _tick = 0L;
    private volatile boolean _reported = false;
    private final Runnable _ticker = new Runnable(){

        @Override
        public void run() {
            ANRWatchDog.this._tick = 0L;
            ANRWatchDog.this._reported = false;
        }
    };

    public ANRWatchDog(int timeoutInterval, ANRListener listener) {
        this._anrListener = listener;
        this._timeoutInterval = timeoutInterval;
    }

    @Override
    public void run() {
        this.setName("|ANR-WatchDog|");
        long interval = this._timeoutInterval;
        while (!this.isInterrupted()) {
            boolean needPost = this._tick == 0L;
            this._tick += interval;
            if (needPost) {
                this._uiHandler.post(this._ticker);
            }
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                Log.w((String)TAG, (String)("Interrupted: " + e.getMessage()));
                return;
            }
            if (this._tick == 0L || this._reported) continue;
            if (Debug.isDebuggerConnected() || Debug.waitingForDebugger()) {
                Log.d((String)TAG, (String)"An ANR was detected but ignored because the debugger is connected.");
                this._reported = true;
                continue;
            }
            Log.d((String)TAG, (String)"Raising ANR");
            String message = "Application Not Responding for at least " + this._timeoutInterval + " ms.";
            ApplicationNotResponding error = new ApplicationNotResponding(message);
            this._anrListener.onAppNotResponding(error);
            interval = this._timeoutInterval;
            this._reported = true;
        }
    }

    public static interface InterruptionListener {
        public void onInterrupted(InterruptedException var1);
    }

    public static interface ANRListener {
        public void onAppNotResponding(ApplicationNotResponding var1);
    }
}

